/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects;

import pt.digitalis.dif.dem.annotations.parameter.FormConfigurable;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.interfaces.ICustomFormDefinition;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;
import pt.digitalis.utils.common.collections.CaseInsentiveArrayList;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// TODO: Auto-generated Javadoc

/**
 * The Class CustomFormDefinition.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 28/01/2014
 */
public class CustomFormDefinition implements ICustomFormDefinition, IObjectFormatter
{

    /**
     * this specific configuration business ID. Is null this configuration is for all instances of the form (or the
     * default ones - this s business defined on a per usage basis)
     */
    private String businessConfigurationID;

    /**
     * List of parameter customizations as defined in the @{@link FormConfigurable} annotation in linkedToForm @
     * {@link Parameter} annotated class fields for given form.
     */
    private Map<String, FormFieldCustomization> customizedParameters = new HashMap<String, FormFieldCustomization>();

    /**
     * List of excluded parameters as defined in the @{@link FormConfigurable} annotation in linkedToForm @
     * {@link Parameter} annotated class fields for given form.
     */
    private List<String> excludedParameters = new CaseInsentiveArrayList();

    /** A map of excluded parameters. */
    private Map<String, FormFieldCustomization> excludedParametersMap = null;

    /** the stage's form name. */
    private String formName;

    /** The stage. */
    private IStage stage;

    /** the stage ID. */
    private String stageID;

    /**
     * Gets the business configuration ID.
     *
     * @return the business configuration ID
     *
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getBusinessConfigurationID()
     */
    @Override
    public String getBusinessConfigurationID()
    {
        return businessConfigurationID;
    }

    /**
     * Modifier for the 'businessConfigurationID' attribute.
     *
     * @param businessConfigurationID the new businessConfigurationID value to set
     */
    public void setBusinessConfigurationID(String businessConfigurationID)
    {
        this.businessConfigurationID = businessConfigurationID;
    }

    /**
     * Gets the customized parameters.
     *
     * @return the customized parameters
     *
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getCustomizedParameters()
     */
    @Override
    public Map<String, FormFieldCustomization> getCustomizedParameters()
    {
        return customizedParameters;
    }

    /**
     * Modifier for the 'customizedParameters' attribute.
     *
     * @param customizedParameters the new customizedParameters value to set
     */
    public void setCustomizedParameters(Map<String, FormFieldCustomization> customizedParameters)
    {
        this.customizedParameters = customizedParameters;
    }

    /**
     * Gets the excluded parameters.
     *
     * @return the excluded parameters
     *
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getExcludedParameters()
     */
    @Override
    public List<String> getExcludedParameters()
    {
        return excludedParameters;
    }

    /**
     * Modifier for the 'excludedParameters' attribute.
     *
     * @param excludedParameters the new excludedParameters value to set
     */
    public void setExcludedParameters(CaseInsentiveArrayList excludedParameters)
    {
        this.excludedParameters = excludedParameters;
    }

    /**
     * Gets the excluded parameters map.
     *
     * @return the excluded parameters map
     *
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getExcludedParametersMap()
     */
    @Override
    public Map<String, FormFieldCustomization> getExcludedParametersMap()
    {

        if (excludedParametersMap == null && !this.excludedParameters.isEmpty())
        {
            excludedParametersMap = new HashMap<String, FormFieldCustomization>();
            for (String excludedParameter : excludedParameters)
            {
                excludedParametersMap.put(excludedParameter, this.getCustomizedParameters().get(excludedParameter));
            }
        }
        return excludedParametersMap;
    }

    /**
     * Gets the form name.
     *
     * @return the form name
     *
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getFormName()
     */
    @Override
    public String getFormName()
    {
        return formName;
    }

    /**
     * Modifier for the 'formName' attribute.
     *
     * @param formName the new formName value to set
     */
    public void setFormName(String formName)
    {
        this.formName = formName;
    }

    /**
     * Inspector for the 'stage' attribute.
     *
     * @return the stage value
     */
    public IStage getStage()
    {
        if (stage == null)
            stage = DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class).getStage(stageID);

        return stage;
    }

    /**
     * Gets the stage ID.
     *
     * @return the stage ID
     *
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getStageID()
     */
    @Override
    public String getStageID()
    {
        return stageID;
    }

    /**
     * Modifier for the 'stageID' attribute.
     *
     * @param stageID the new stageID value to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }

    /**
     * Checks if is field read only.
     *
     * @param fieldName the field name
     *
     * @return the boolean
     *
     * @exception ParameterException the parameter exception
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#isFieldReadOnly(java.lang.String)
     */
    @Override
    public Boolean isFieldReadOnly(String fieldName) throws ParameterException
    {

        IParameter<?> param = getStage().getParameters().getStageParameters().getParameter(fieldName);
        if (param == null)
        {
            return false;
        }

        /* The IParameter.isReadonly feature was removed, due to lack of usage */
        // Boolean isParameterReadOnly = param.isReadonly();
        Boolean isParameterReadOnly = false;

        // Not custumized will assume the Parameter required value
        if (this.getCustomizedParameters().get(fieldName.toLowerCase()) == null)
            return isParameterReadOnly;

        // If is excluded will assume not required
        if (this.getExcludedParameters().contains(fieldName.toLowerCase()))
            return false;

        // Otherwize will assum the customized definition as readonly or not
        return this.getCustomizedParameters().get(fieldName.toLowerCase()).getReadOnly().equals(FeatureState.ON);
    }

    /**
     * Checks if is field required.
     *
     * @param fieldName the field name
     *
     * @return the boolean
     *
     * @exception ParameterException the parameter exception
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#isFieldRequired(java.lang.String)
     */
    @Override
    public Boolean isFieldRequired(String fieldName) throws ParameterException
    {

        IParameter<?> param = getStage().getParameters().getStageParameters().getParameter(fieldName);
        if (param == null)
        {
            return false;
        }

        Boolean isParameterRequired = param.isRequired();

        // Not custumized will assume the Parameter required value
        if (this.getCustomizedParameters().get(fieldName.toLowerCase()) == null)
            return isParameterRequired;

        // If is excluded will assume not required
        if (this.getExcludedParameters().contains(fieldName.toLowerCase()))
            return false;

        // Otherwize will assum the customized definition as mandatory or not
        return this.getCustomizedParameters().get(fieldName.toLowerCase()).getMandatory().equals(FeatureState.ON);
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItem("stageID", this.stageID);
        formatter.addItem("formName", this.formName);
        formatter.addItem("businessID", this.businessConfigurationID);
        formatter.addItem("excludedParameters", this.excludedParameters);
        formatter.addItem("customizedParameters", this.customizedParameters);
        formatter.addItem("excludedParametersMap", this.excludedParametersMap);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
