/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.messages;

import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.List;

/**
 * Represents a message item.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Nov 2, 2007
 */
public class Message implements IObjectFormatter
{

    /** Customized message */
    private String customMessage;

    /** The message */
    private String message;

    /**
     * Constructor
     *
     * @param message the message
     */
    public Message(String message)
    {
        this(message, null);
    }

    /**
     * Constructor
     *
     * @param message       the message
     * @param customMessage the customized message
     */
    public Message(String message, String customMessage)
    {
        this.message = message;
        this.customMessage = customMessage;
    }

    /**
     * Gets default message.
     *
     * @return the Default Message
     */
    public String getDefaultMessage()
    {
        return message;
    }

    /**
     * Gets message.
     *
     * @return the message
     */
    public String getMessage()
    {
        return (customMessage == null ? message : customMessage);
    }

    /**
     * Is customized boolean.
     *
     * @return T if the message has been customized
     */
    public boolean isCustomized()
    {
        return (customMessage != null);
    }

    /**
     * To object formatter object formatter.
     *
     * @param format        the format
     * @param dumpedObjects the dumped objects
     *
     * @return the object formatter
     */
    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);

        formatter.addItem("Message", message);
        formatter.addItemIfNotNull("Custom Message", customMessage);

        return formatter;
    }

    /**
     * To string string.
     *
     * @return the string
     *
     * @see java.lang.Object#toString() java.lang.Object#toString()java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}