/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.messages;

import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The translations of a message
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 2, 2007
 */
public class MessageTranslations implements IObjectFormatter
{

    /** The translations */
    private Map<String, Message> translations = new HashMap<String, Message>();

    /**
     * Adds a new translation to the map.
     *
     * @param language the language of the translation
     * @param message  the message object
     *
     * @return the updated object
     */
    public MessageTranslations addTranslation(String language, Message message)
    {

        language = processLanguage(language);

        translations.put(language.toLowerCase(), message);

        return this;
    }

    /**
     * Returns a message translation for a given language.
     *
     * @param language the language of the translation
     *
     * @return the message of the given language
     */
    public Message getMessage(String language)
    {

        language = processLanguage(language);

        Message message = translations.get(language);

        if (message == null)
        {
            if (language != DIFGeneralConfigurationParameters.getInstance().getDefaultLanguage())
                return translations.get(DIFGeneralConfigurationParameters.getInstance().getDefaultLanguage());
            else
            {
                if (translations.keySet().size() > 0)
                    return (Message) translations.values().toArray()[0];
            }
        }

        return message;
    }

    /**
     * Returns all the translations for the message.
     *
     * @return the message translations
     */
    public Map<String, Message> getTranslations()
    {
        return this.translations;
    }

    /**
     * Takes a language as argument and processes it according to the following rule: - if null was passed use DiF's
     * default language - if not null the language is converted to lower-case
     *
     * @param language the language
     *
     * @return the lower-case version of the language or DiF's default language.
     */
    private String processLanguage(String language)
    {
        // If language wasn't pass, revert back to default
        if (language == null)
            return DIFGeneralConfigurationParameters.getInstance().getDefaultLanguage();
            // ...else use the passed language lower case version
        else
            return language.toLowerCase();
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItem("Translations", translations);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
