/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.messages;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 15, 2007
 */
public enum MessagesLocation
{

    /** Searches for messages in the same path of the entity class. */
    CLASS_LOCATION,
    /** Searches for messages in the default /messages/** folder. */
    MESSAGES_FOLDER;

    /**
     * Returns the message location of a given name.
     *
     * @param name selected method name
     *
     * @return the Message location for the given name
     */
    static public MessagesLocation getMessageLocationByName(String name)
    {
        if (name.equalsIgnoreCase(CLASS_LOCATION.toString()))
            return CLASS_LOCATION;

        return MESSAGES_FOLDER;
    }
}