package pt.digitalis.dif.dem.objects.parameters;

/**
 * The Enum FormConfigurableType.
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 10/12/2018
 */
public class FormConfigurableDefinition
{

    /** The mandatory. */
    private boolean canEditMandatory = false;

    /** The can edid read only */
    private boolean canEditReadOnly = false;

    /** The can edit text. */
    private boolean canEditText = false;

    /** The configurable. */
    private boolean configurable = false;

    /**
     * Inspector for the 'canEditMandatory' attribute.
     *
     * @return the canEditMandatory value
     */
    public boolean isCanEditMandatory()
    {
        return canEditMandatory;
    }

    /**
     * Modifier for the 'canEditMandatory' attribute.
     *
     * @param canEditMandatory the new canEditMandatory value to set
     */
    public void setCanEditMandatory(boolean canEditMandatory)
    {
        this.canEditMandatory = canEditMandatory;
    }

    /**
     * Inspector for the 'canEditReadOnly' attribute.
     *
     * @return the canEditReadOnly value
     */
    public boolean isCanEditReadOnly()
    {
        return canEditReadOnly;
    }

    /**
     * Modifier for the 'canEditReadOnly' attribute.
     *
     * @param canEditReadOnly the new canEditReadOnly value to set
     */
    public void setCanEditReadOnly(boolean canEditReadOnly)
    {
        this.canEditReadOnly = canEditReadOnly;
    }

    /**
     * Checks if is can edit text.
     *
     * @return true, if is can edit text
     */
    public boolean isCanEditText()
    {
        return canEditText;
    }

    /**
     * Modifier for the 'canEditText' attribute.
     *
     * @param canEditText the new canEditText value to set
     */
    public void setCanEditText(boolean canEditText)
    {
        this.canEditText = canEditText;
    }

    /**
     * Inspector for the 'configurable' attribute.
     *
     * @return the configurable value
     */
    public boolean isConfigurable()
    {
        return configurable;
    }

    /**
     * Modifier for the 'configurable' attribute.
     *
     * @param configurable the new configurable value to set
     */
    public void setConfigurable(boolean configurable)
    {
        this.configurable = configurable;
    }
}
