/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.utils.config.ConfigurationException;

/**
 * Defines an utility for parameter access for stages. It facilitates the access to all parameters of the stage and all
 * hierachical entities above it. Allows reading and writing of parameter values.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 22, 2007
 */
public interface IParameters
{

    /**
     * Adds a new parameter to the current stage
     *
     * @param <T>                  the parameter class type
     * @param parameterClass       the new parameter class
     * @param parameterID          the new parameter ID
     * @param parameterScope       the parameter scope
     * @param defaultValue         the default parameter
     * @param constraintDefinition
     *
     * @return the newly created parameter (already added to the stage)
     *
     * @exception ParameterException
     * @exception ConfigurationException
     */
    public <T extends IParameter<?>> T addStageParameter(Class<T> parameterClass, String parameterID,
            ParameterScope parameterScope, String defaultValue, String constraintDefinition)
            throws ParameterException, ConfigurationException;

    /**
     * Retrieves all parameters. Gathers parameters for the stage, service, application and stage in a unique Map.
     *
     * @return the parameter list
     *
     * @exception ParameterException if there was an error refreshing the parameter values
     */
    public ParameterList getAllAvailableParameters() throws ParameterException;

    /**
     * Retrieves all application parameters. Without hierachical inheritance.
     *
     * @return the parameter list
     *
     * @exception ParameterException if there was an error refreshing the parameter values
     */
    public ParameterList getApplicationParameters() throws ParameterException;

    /**
     * Retrieves all provider parameters. Without hierachical inheritance.
     *
     * @return the parameter list
     *
     * @exception ParameterException if there was an error refreshing the parameter values
     */
    public ParameterList getProviderParameters() throws ParameterException;

    /**
     * Retrieves all service parameters. Without hierarchical inheritance.
     *
     * @return the parameter list
     *
     * @exception ParameterException if there was an error refreshing the parameter values
     */
    public ParameterList getServiceParameters() throws ParameterException;

    /**
     * Retrieves all stage parameters. Without hierachical inheritance.
     *
     * @return the parameter list
     *
     * @exception ParameterException if there was an error refreshing the parameter values
     */
    public ParameterList getStageParameters() throws ParameterException;

    /**
     * Initialize the parameter object, reading all parameter values from all scopes and sources
     *
     * @param stage the stage
     */
    public void initialize(IStageInstance stage);
}
