/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.parameters.constraints;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Mar 31, 2010
 */
public class ParameterConstraintResult
{

    /** The constraint that created the result */
    private IParameterConstraint constraint;

    /** The constraint error IDs */
    private List<String> errorIDs = new ArrayList<String>();

    /** The language used to serve the constraint messages */
    private String language;

    /** The constraint validation result */
    private boolean valid;

    /**
     * Constructor
     *
     * @param constraint The constraint that created the result
     * @param result     The constraint validation result
     * @param errorIDs   The constraint error IDs
     * @param language   The language used to serve the constraint messages
     */
    public ParameterConstraintResult(IParameterConstraint constraint, boolean result, List<String> errorIDs,
            String language)
    {
        this.constraint = constraint;
        this.valid = result;
        this.errorIDs = errorIDs;
        this.language = language;
    }

    /**
     * Constructor
     *
     * @param constraint The constraint that created the result
     * @param valid      The constraint validation result
     * @param language   The language used to serve the constraint messages
     */
    public ParameterConstraintResult(IParameterConstraint constraint, boolean valid, String language)
    {
        this.constraint = constraint;
        this.valid = valid;
        this.language = language;
    }

    /**
     * Inspector for the 'constraint' attribute.
     *
     * @return the constraint value
     */
    public IParameterConstraint getConstraint()
    {
        return constraint;
    }

    /**
     * Inspector for the 'errorIDs' attribute.
     *
     * @return the errorIDs value
     */
    public List<String> getErrorIDs()
    {
        return errorIDs;
    }

    /**
     * Modifier for the 'errorIDs' attribute.
     *
     * @param errorIDs the new errorIDs value to set
     */
    public void setErrorIDs(List<String> errorIDs)
    {
        this.errorIDs = errorIDs;
    }

    /**
     * Inspector for the 'language' attribute.
     *
     * @return the language value
     */
    public String getLanguage()
    {
        return language;
    }

    /**
     * Inspector for the 'result' attribute.
     *
     * @return the result value
     */
    public boolean isValid()
    {
        return valid;
    }

    /**
     * Modifier for the 'result' attribute.
     *
     * @param result the new result value to set
     */
    public void setResult(boolean result)
    {
        this.valid = result;
    }
}
