/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric;

import pt.digitalis.dif.dem.interfaces.IStageInstance;

import java.util.HashMap;
import java.util.Map;

/**
 * Numeric parameter constraint implementation
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 16, 2007
 */
public class ParameterConstraintNumericImpl extends AbstractNumericParameterConstraint
{

    /** Last tested value */
    String lastTestedValue;

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#configureConstraint(java.lang.String)
     */
    public void configureConstraint(String configurationString)
    {
        // Nothing to do. No parameters to parse.
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.AbstractParameterConstraint#getErrorMessageValues(boolean)
     */
    @Override
    protected Map<String, String> getErrorMessageValues(boolean parseValues)
    {
        Map<String, String> substitutions = new HashMap<String, String>();

        if (parseValues)
        {
            substitutions.put("value", lastTestedValue);
        }

        return substitutions;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#getJavaScriptValidationCondition()
     */
    public String getJavaScriptValidationCondition()
    {
        return "Ext.isNumeric(value)";
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric.AbstractNumericParameterConstraint#validateConstraint(java.lang.Double,
     *         pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    @Override
    public boolean validateConstraint(Double value, IStageInstance stageInstance)
    {
        // If it's a boolean it's already validated. Only have to implement this because of the BaseNumericImpl. It will
        // never be called.
        return true;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric.AbstractNumericParameterConstraint#validateConstraint(java.lang.String,
     *         pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    @Override
    public boolean validateConstraint(String value, IStageInstance stageInstance)
    {

        lastTestedValue = value;

        if (value == null || "".equals(value) || "undefined".equals(value))
            return true;
        else
            try
            {
                value = value.replace(',', '.');

                Double.valueOf(value);

                return true;
            }
            catch (NumberFormatException e)
            {
                return false;
            }
    }
}
