/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.errors;

import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

import java.util.ArrayList;
import java.util.List;

/**
 * A list of parameter errors for a given parameter
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 */
public class ParameterErrorList implements IObjectFormatter
{

    /** The value that was attempted to pass to the parameter */
    private Object attemptedValue;

    /**
     * The list of errors for the given parameter
     */
    private List<ParameterError> errorList = new ArrayList<ParameterError>();

    /** The parameter to witch the errors refer to */
    private IParameter<?> parameter;

    /**
     * Default constructor
     *
     * @param parameter      the parameter that caused the error
     * @param attemptedValue the value that was attempted to pass to the parameter
     */
    public ParameterErrorList(IParameter<?> parameter, Object attemptedValue)
    {
        this.parameter = parameter;
        this.attemptedValue = attemptedValue;
    }

    /**
     * Adds an error to the list
     *
     * @param error the error to add
     */
    public void addError(ParameterError error)
    {
        this.errorList.add(error);
    }

    /**
     * Add error list.
     *
     * @param errorList the errorList to add
     */
    public void addErrorList(List<ParameterError> errorList)
    {
        this.errorList.addAll(errorList);
    }

    /**
     * Gets attempted value.
     *
     * @return the attemptedValue
     */
    public Object getAttemptedValue()
    {
        return attemptedValue;
    }

    /**
     * Gets error list.
     *
     * @return the errorList
     */
    public List<ParameterError> getErrorList()
    {
        return errorList;
    }

    /**
     * Sets error list.
     *
     * @param errorList the errorList to set
     */
    public void setErrorList(List<ParameterError> errorList)
    {
        this.errorList = errorList;
    }

    /**
     * Gets parameter.
     *
     * @return the parameter
     */
    public IParameter<?> getParameter()
    {
        return parameter;
    }

    /**
     * To object formatter object formatter.
     *
     * @param format        the format
     * @param dumpedObjects the dumped objects
     *
     * @return the object formatter
     *
     * @see pt.digitalis.dif.utils.IObjectFormatter#toObjectFormatter(pt.digitalis.dif.utils.ObjectFormatter.Format)
     *         pt.digitalis.dif.utils.IObjectFormatter#toObjectFormatter(pt.digitalis.dif.utils.ObjectFormatter.Format)
     */
    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItem("Parameter", parameter);
        formatter.addItem("Attempted Value", attemptedValue);
        formatter.addItem("Error List", errorList);

        return formatter;
    }

    /**
     * To string string.
     *
     * @return the string
     *
     * @see java.lang.Object#toString() java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
