/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.parameters.rules;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.types.AbstractParameter;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.utils.config.ConfigurationException;

import java.util.List;

/**
 * A parameter rule object
 *
 * @param <T> generic type of the parameter
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Mar 31, 2009
 */
public interface IParameterRule<T>
{

    /**
     * Inspector for the 'action' attribute.
     *
     * @return the action value
     */
    public ParameterRuleAction getAction();

    /**
     * Inspector for the 'descriptionEndValue' attribute.
     *
     * @return the descriptionEndValue value
     */
    public String getDescriptionEndValue();

    /**
     * Modifier for the 'descriptionEndValue' attribute.
     *
     * @param descriptionEndValue the new descriptionEndValue value to set
     */
    public void setDescriptionEndValue(String descriptionEndValue);

    /**
     * Inspector for the 'descriptionStartValue' attribute.
     *
     * @return the descriptionStartValue value
     */
    public String getDescriptionStartValue();

    /**
     * Modifier for the 'descriptionStartValue' attribute.
     *
     * @param descriptionStartValue the new descriptionStartValue value to set
     */
    public void setDescriptionStartValue(String descriptionStartValue);

    /**
     * Inspector for the 'descriptionValue' attribute.
     *
     * @return the descriptionValue value
     */
    public String getDescriptionValue();

    /**
     * Modifier for the 'descriptionValue' attribute.
     *
     * @param descriptionValue the new descriptionValue value to set
     */
    public void setDescriptionValue(String descriptionValue);

    /**
     * Inspector for the 'endValue' attribute.
     *
     * @return the endValue value
     */
    public String getEndValue();

    /**
     * Inspector for the 'parameters' attribute.
     *
     * @return the parameters value
     */
    public List<String> getParameters();

    /**
     * Inspector for the 'startValue' attribute.
     *
     * @return the startValue value
     */
    public String getStartValue();

    /**
     * Gets the validation result for the present parameter
     *
     * @param stage                    the current stage
     * @param value                    the value to validate
     * @param initializationInProgress T if called within the dif parameter initialization
     * @param parameter                the parameter for validation
     *
     * @return the validation rule validation result
     *
     * @exception ParameterException     if the parameter does not exist
     * @exception ConfigurationException
     */
    public ParameterRuleResult getValidationResult(IStageInstance stage, T value, boolean initializationInProgress,
            AbstractParameter<T> parameter) throws ParameterException, ConfigurationException;

    /**
     * Inspector for the 'value' attribute.
     *
     * @return the value value
     */
    public String getValue();

    /**
     * Initializer
     *
     * @param parameterID the rule parameter ID
     * @param parameters  the list of parameters relevant for the given rule (besides the current parameter)
     * @param action      the action to perform according to the rule activation (valid or invalid)
     * @param value       the value for comparison
     * @param first       the first value for interval comparison
     * @param last        the last value for interval comparison
     *
     * @return the initialized object
     */
    public AbstractParameterRule<T> init(String parameterID, String parameters, ParameterRuleAction action,
            String value, String first, String last);

    /**
     * Modifier for the 'endValue' attribute.
     *
     * @param endValue the new endValue value to set
     *
     * @return the updated parameter rule instance
     */
    public AbstractParameterRule<T> setEndValue(String endValue);

    /**
     * Modifier for the 'startValue' attribute.
     *
     * @param startValue the new startValue value to set
     *
     * @return the updated parameter rule instance
     */
    public AbstractParameterRule<T> setStartValue(String startValue);

    /**
     * Modifier for the 'value' attribute.
     *
     * @param value the new value value to set
     *
     * @return the updated parameter rule instance
     */
    public AbstractParameterRule<T> setValue(String value);
}
