/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.parameters.rules;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.dem.objects.parameters.ParameterList;
import pt.digitalis.dif.dem.objects.parameters.types.AbstractParameter;
import pt.digitalis.dif.dem.objects.parameters.types.BooleanParameter;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.config.ConfigurationException;

import java.util.ArrayList;
import java.util.List;

// TODO: Auto-generated Javadoc

/**
 * Exclusive parameter rule. Validates if the given parameter is not selected along with other exclusive fill parameter.
 * Only one can have a filled value.
 *
 * @param <T> the parameter base type
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Mar 31, 2009
 */
public class ParameterRuleExclusive<T> extends AbstractParameterRule<T>
{

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.rules.IParameterRule#getValidationResult(pt.digitalis.dif.dem.interfaces.IStageInstance,
     *         java.lang.Object, boolean, pt.digitalis.dif.dem.objects.parameters.types.AbstractParameter)
     */
    public ParameterRuleResult getValidationResult(IStageInstance stage, T value, boolean initializationInProgress,
            AbstractParameter<T> parameter) throws ParameterException, ConfigurationException
    {
        List<IParameter<?>> filledParameters = new ArrayList<IParameter<?>>();

        if (getParameters() == null || getParameters().isEmpty())
            return new ParameterRuleResult(true);

        else
        {
            ParameterList list = stage.getParameters().getAllAvailableParameters();

            List<String> parametersToCheck = new ArrayList<String>();
            parametersToCheck.addAll(this.getParameters());
            if (value != null)
            {
                filledParameters.add(parameter);
            }

            for (String parameterID : parametersToCheck)
            {
                IParameter<?> param = null;
                boolean isFilled = false;

                try
                {
                    param = list.getParameter(parameterID);

                    boolean skipValidation = this.refreshAssociatedParam(stage, param, initializationInProgress);

                    if (!skipValidation)
                    {
                        if (param instanceof BooleanParameter)
                        {
                            BooleanParameter boolParam = (BooleanParameter) param;
                            isFilled = boolParam.getValue(stage.getContext());
                        }
                        else
                        {
                            isFilled = param.getValue(stage.getContext()) != null;
                        }

                        if (isFilled)
                            filledParameters.add(param);
                    }
                }
                catch (ParameterException e)
                {
                    BusinessException be = new BusinessException(
                            "Error validating dependent parameter for " + this.getClass().getSimpleName(), e);
                    be.addToExceptionContext("Rule", this).addToExceptionContext("Parameter", parameter)
                            .addToExceptionContext("Value", value).log(LogLevel.ERROR);
                }
            }

            if (filledParameters.size() <= 1)
                return new ParameterRuleResult(true);

            else
            {
                StringBuffer buffer = new StringBuffer();

                buffer.append(this.getMessages(stage).get("onlyOne") + ": ");
                buffer.append("\"" + getParameterName(stage, parameterID) + "\"");

                for (String linkedParameterIDs : this.getParameters())
                {
                    buffer.append(", \"" + getParameterName(stage, linkedParameterIDs) + "\"");
                }

                return new ParameterRuleResult(buffer.toString());
            }
        }
    }
}
