/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.parameters.rules;

/**
 * Result of a parameter rule validation
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Mar 31, 2009
 */
public class ParameterRuleResult
{

    /** The error message if the rule was not valid */
    private String errorMessage;

    /** T if the ruke was validated successfully */
    private boolean valid;

    /**
     * @param valid
     */
    public ParameterRuleResult(boolean valid)
    {
        this.valid = valid;
        this.errorMessage = null;
    }

    /**
     * @param errorMessage
     */
    public ParameterRuleResult(String errorMessage)
    {
        this.valid = false;
        this.errorMessage = errorMessage;
    }

    /**
     * Inspector for the 'errorMessage' attribute.
     *
     * @return the errorMessage value
     */
    public String getErrorMessage()
    {
        return errorMessage;
    }

    /**
     * Modifier for the 'errorMessage' attribute.
     *
     * @param errorMessage the new errorMessage value to set
     */
    public void setErrorMessage(String errorMessage)
    {
        this.errorMessage = errorMessage;
    }

    /**
     * Inspector for the 'valid' attribute.
     *
     * @return the valid value
     */
    public boolean isValid()
    {
        return valid;
    }

    /**
     * Modifier for the 'valid' attribute.
     *
     * @param valid the new valid value to set
     */
    public void setValid(boolean valid)
    {
        this.valid = valid;
    }
}
