/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.types;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrorList;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.utils.config.ConfigurationException;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class will define a numeric Parameter.
 * <p>
 * It will hold information relative to the Parameter value, ID key and validation constraints.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gon�alves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 23, 2007
 */
public class BooleanParameter extends AbstractParameter<Boolean>
{

    /** The list of supported classes to define in the concrete implementations */
    @SuppressWarnings("serial")
    final static private List<String> supportedClasses = new ArrayList<String>()
    {

        {
            add(Boolean.class.getCanonicalName());
        }
    };

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#getSupportedClasses()
     */
    public List<String> getSupportedClasses()
    {
        return supportedClasses;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.types.AbstractParameter#getValue(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    @Override
    public Boolean getValue(IDIFContext context) throws ParameterException
    {
        Boolean temp = super.getValue(context);

        if (temp == null)
            return false;
        else
            return temp;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#getValueAsBigDecimal(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    public BigDecimal getValueAsBigDecimal(IDIFContext context) throws ParameterException
    {
        return (getValue(context) ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L));
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#getValueAsBoolean(IDIFContext)
     */
    public boolean getValueAsBoolean(IDIFContext context) throws ParameterException
    {
        Boolean value = getValue(context);

        if (value == null)
            return false;
        else
            return value.booleanValue();
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#getValueAsDate(IDIFContext)
     */
    public Date getValueAsDate(IDIFContext context)
    {
        return null;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#getValueAsDouble(IDIFContext)
     */
    public Double getValueAsDouble(IDIFContext context) throws ParameterException
    {
        return (getValue(context) ? 1D : 0D);
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#getValueAsLong(IDIFContext)
     */
    public Long getValueAsLong(IDIFContext context) throws ParameterException
    {
        return (getValue(context) ? 1L : 0L);
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.types.AbstractParameter#getValueAsString(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    @Override
    public String getValueAsString(IDIFContext context) throws ParameterException
    {
        return Boolean.toString(getValueAsBoolean(context));
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#isNumeric()
     */
    public boolean isNumeric()
    {
        return false;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameter#setValueFromString(java.lang.String,
     *         pt.digitalis.dif.dem.interfaces.IStageInstance, boolean)
     */
    public ParameterErrorList setValueFromString(String value, IStageInstance stageInstance,
            boolean initializationInProgress) throws ConfigurationException
    {
        if (value == null || "".equals(value))
            return setValue(null, stageInstance);
        else
        {
            value = value.toLowerCase();
            value = value.replace("on", "true");
            value = value.replace("off", "false");
            value = value.replace("yes", "true");
            value = value.replace("no", "false");

            return setValue(Boolean.parseBoolean(value), stageInstance, initializationInProgress);
        }
    }
}
