/**
 * 2016, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.parameters.types;

import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 18/04/2016
 */
public class StringArray extends ArrayList<String>
{

    /**
     *
     */
    private static final long serialVersionUID = -5488542915988058660L;

    /**
     *
     */
    public StringArray()
    {
        super();
    }

    /**
     * @param itens
     */
    public StringArray(Collection<? extends String> itens)
    {
        super(itens);
    }

    /**
     * @param initialCapacity
     */
    public StringArray(int initialCapacity)
    {
        super(initialCapacity);
    }

    /**
     * @param commaSeparatedItems
     */
    public StringArray(String commaSeparatedItems)
    {
        super();

        this.setFromCommaSeparatedString(commaSeparatedItems);
    }

    /**
     * @return the current list as a comma separated values list
     */
    public String getAsCommaSeparatedString()
    {
        return CollectionUtils.listToCommaSeparatedString(this);
    }

    /**
     * Fills the list with a given comma separated string. All previous entries will be deleted and all new items will
     * be trimmed
     *
     * @param commaSeparatedString
     */
    public void setFromCommaSeparatedString(String commaSeparatedString)
    {
        this.clear();

        if (StringUtils.isNotBlank(commaSeparatedString))
        {
            for (String valueEntry : new StringArray(Arrays.asList(commaSeparatedString.split(","))))
            {
                this.add(valueEntry.trim());
            }
        }
    }
}
