/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * Used to launch a business exception destined to encapsulate a specific error or exception and the context at the
 * calling moment
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 11/11/2014
 */
public class BusinessException extends DIFException
{

    /**
     *
     */
    private static final long serialVersionUID = -6222436802754664119L;

    /**
     * Constructor without business message.<br/>
     * Will be removed in a future version. DO NOT USE!!!
     *
     * @param exception
     */
    @Deprecated
    public BusinessException(Exception exception)
    {
        super(exception);
    }

    /**
     * @param reason
     */
    public BusinessException(String reason)
    {
        super(reason);
    }

    /**
     * @param reason
     * @param exception
     */
    public BusinessException(String reason, Exception exception)
    {
        super(reason, exception);
    }

    /**
     * @see pt.digitalis.dif.exception.DIFException#getRenderedExceptionContext()
     */
    @Override
    public String getRenderedExceptionContext()
    {
        return "Business error found:\n" + super.getRenderedExceptionContext();
    }

    /**
     * @see java.lang.Throwable#printStackTrace()
     */
    @Override
    public void printStackTrace()
    {
        System.out.println(this.getRenderedExceptionContext());

        super.printStackTrace();
    }

    /**
     * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
     */
    @Override
    public void printStackTrace(PrintStream stream)
    {
        stream.append(this.getRenderedExceptionContext());
        stream.append("\n");

        super.printStackTrace(stream);
    }

    /**
     * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
     */
    @Override
    public void printStackTrace(PrintWriter writer)
    {
        writer.println(this.getExceptionContext());

        super.printStackTrace(writer);
    }
}
