/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.exception;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * Represents an internal framework Exception. The execution context is passed into the exception.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/03/16
 * @see DIFException
 */
public class InternalFrameworkException extends DIFException
{

    /** Serial Version ID. */
    private static final long serialVersionUID = 1120934514453714926L;

    /** The execution context. */
    private IDIFContext difContext;

    /**
     * Constructs a new InternalFrameworkException from an Exception.
     *
     * @param exception  the exception to encapsulate
     * @param difContext the execution context
     */
    public InternalFrameworkException(Exception exception, IDIFContext difContext)
    {
        super(exception);
        this.difContext = difContext;
    }

    /**
     * Constructs a new InternalFrameworkException accepting a reason for the exception
     *
     * @param reason     the exception cause
     * @param exception  the exception to encapsulate
     * @param difContext the execution context
     */
    public InternalFrameworkException(String reason, Exception exception, IDIFContext difContext)
    {
        super(reason, exception);
        this.difContext = difContext;
    }

    /**
     * Constructs a new InternalFrameworkException from a reason for the exception.
     *
     * @param reason     the exception cause
     * @param difContext the execution context
     */
    public InternalFrameworkException(String reason, IDIFContext difContext)
    {
        super(reason);
        this.difContext = difContext;
    }

    /**
     * Returns the stored DIFContext.
     *
     * @return the difContext
     */
    public IDIFContext getDIFContext()
    {
        return difContext;
    }

    /**
     * Sets the DIFContext content.
     *
     * @param difContext the difContext to set
     */
    public void setDifContext(IDIFContext difContext)
    {
        this.difContext = difContext;
    }
}
