/**
 * 2017, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 27/06/2017
 */
public class UnsupportedAction extends DIFException
{

    /**
     *
     */
    private static final long serialVersionUID = 3498527341255175277L;

    /**
     * @param exception
     */
    public UnsupportedAction(Exception exception)
    {
        super(exception);
    }

    /**
     * @param reason
     */
    public UnsupportedAction(String reason)
    {
        super(reason);
    }

    /**
     * @param reason
     * @param exception
     */
    public UnsupportedAction(String reason, Exception exception)
    {
        super(reason, exception);
    }

    /**
     * Defaults to a message that states that cannot call the method where the error occurred
     *
     * @exception UnsupportedAction
     */
    static public void throwException() throws UnsupportedAction
    {
        StackTraceElement[] traceArray = Thread.currentThread().getStackTrace();
        String message = null;

        if (traceArray.length > 1)
        {
            StackTraceElement element = traceArray[1];
            message = "Cannot call " + element.getMethodName() + " on class " + element.getClassName();
        }
        else
        {
            message = "Cannot execute given action!";
        }

        throw new UnsupportedAction(message);
    }
}
