/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception.codegen;

import java.util.Map;

/**
 * Exception raised by the validation module when two incompatible primary DEM Annotations are used on the same element.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/11/29
 */
public class IncompatiblePrimaryAnnotationsException extends AnnotationMisuseException
{

    /** The tag for 'attribute scope' annotations. */
    final static public String ATTRIBUTE_SCOPE = "ATTRIBUTE SCOPE";

    /** The tag for 'class scope' annotations. */
    final static public String CLASS_SCOPE = "CLASS SCOPE";

    /** The message associated with incompatible primary annotation misuse. */
    final static public String INCOMPATIBLE_PRIMARY_ANNOTATIONS_MESSAGE =
            "Incompatible primary annotations used on the same element!";

    /** The tag for 'method scope' annotations. */
    final static public String METHOD_SCOPE = "METHOD SCOPE";

    /** Serial Version ID. */
    private static final long serialVersionUID = 7696717647937187244L;

    /**
     * Constructs a new IncompatiblePrimaryAnnotationsException from a reason, an exception and an exception context.
     *
     * @param reason           the exception reason.
     * @param exception        the exception to encapsulate.
     * @param exceptionContext the exception context.
     */
    public IncompatiblePrimaryAnnotationsException(String reason, Exception exception,
            Map<String, Object> exceptionContext)
    {
        super(reason, exception, exceptionContext);
    }

    /**
     * Constructs a new IncompatiblePrimaryAnnotationsException from a reason and an exception context.
     *
     * @param reason           the exception reason.
     * @param exceptionContext the exception context.
     */
    public IncompatiblePrimaryAnnotationsException(String reason, Map<String, Object> exceptionContext)
    {
        super(reason, exceptionContext);
    }
}
