/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.exception.controller;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.exception.InternalFrameworkException;

/**
 * This exception represents a Business Exception. Whenever an exception is thrown in a stage execution this will be
 * launched by the Dispatcher.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 21, 2007
 */
public class BusinessFlowException extends InternalFrameworkException
{

    /**
     *
     */
    private static final long serialVersionUID = 0L;

    /**
     * Constructs a new BusinessFlowException from an Exception.
     *
     * @param exception  the exception to encapsulate
     * @param difContext the execution context
     */
    public BusinessFlowException(Exception exception, IDIFContext difContext)
    {
        super(exception, difContext);
    }

    /**
     * Constructs a new BusinessFlowException accepting a reason for the exception
     *
     * @param reason     the exception cause
     * @param exception  the exception to encapsulate
     * @param difContext the execution context
     */
    public BusinessFlowException(String reason, Exception exception, IDIFContext difContext)
    {
        super(reason, exception, difContext);
    }

    /**
     * Constructs a new BusinessFlowException from a reason for the exception.
     *
     * @param reason     the exception cause
     * @param difContext the execution context
     */
    public BusinessFlowException(String reason, IDIFContext difContext)
    {
        super(reason, difContext);
    }
}
