/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.exception.objects;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.exception.DIFException;

/**
 * Exception for IParameter operations
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 */
public class ParameterException extends DIFException
{

    /** The tag for 'parameter' annotations. */
    final static private String CONTEXT = "CONTEXT";

    /** The tag for 'parameter' annotations. */
    final static private String PARAMETER = "PARAMETER";

    /** Serial Version ID. */
    private static final long serialVersionUID = -3450110830894378355L;

    /** The tag for 'parameter' annotations. */
    final static private String STAGE = "STAGE";

    /**
     * Constructor
     *
     * @param reason    the reason for the exception
     * @param exception the exception thrown
     * @param parameter the parameter that generated the exception
     */
    public ParameterException(String reason, Exception exception, IParameter<?> parameter)
    {
        super(reason, exception);
        setParameter(parameter);
    }

    /**
     * Constructor
     *
     * @param reason    the reason for the exception
     * @param parameter the parameter that generated the exception
     */
    public ParameterException(String reason, IParameter<?> parameter)
    {
        super(reason);
        setParameter(parameter);
    }

    /**
     * @param context the stage to set
     */
    public void setContext(IDIFContext context)
    {
        addToExceptionContext(CONTEXT, context);
    }

    /**
     * @param parameter the parameter to set
     */
    public void setParameter(IParameter<?> parameter)
    {
        addToExceptionContext(PARAMETER, parameter);
    }

    /**
     * @param stage the stage to set
     */
    public void setStage(IStage stage)
    {
        addToExceptionContext(STAGE, stage);
    }
}
