/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception.security;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.exception.DIFException;

/**
 * Identity manager related exception.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/04/15
 */
public class IdentityManagerException extends DIFException
{

    /** The serial ID. */
    final static private long serialVersionUID = 1L;

    /** isReadOnly value */
    private boolean isReadOnlyException = false;

    /**
     * Constructs a new IdentityManagerException that wraps a Java Exception.
     *
     * @param exception the exception to encapsulate.
     */
    public IdentityManagerException(Exception exception)
    {
        super(exception);
    }

    /**
     * Constructs a new IdentityManagerException from a reason.
     *
     * @param reason the exception reason.
     */
    public IdentityManagerException(String reason)
    {
        super(reason);
    }

    /**
     * Constructs a new IdentityManagerException from a reason and a Java Exception.
     *
     * @param reason    the exception reason.
     * @param exception the exception to encapsulate.
     */
    public IdentityManagerException(String reason, Exception exception)
    {
        super(reason, exception);
    }

    /**
     * @return T if the current exception was thrown because the {@link IIdentityManager} is in readonly mode
     */
    public Boolean isReadOnlyException()
    {
        return isReadOnlyException;
    }

    /**
     * Modifier for the 'isReadOnlyException' attribute.
     *
     * @param isReadOnlyException the new isReadOnlyException value to set
     */
    public void setReadOnlyException(boolean isReadOnlyException)
    {
        this.isReadOnlyException = isReadOnlyException;
    }
}
