package pt.digitalis.dif.features;

import pt.digitalis.dif.exception.security.IdentityManagerException;

/**
 * Base Authentication features
 *
 * @author Joo Galaio <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 7 Nov 2016
 */
public interface IDIFFeatureBaseAuthentication extends IDIFFeature
{

    /**
     * Gets the image path.
     *
     * @return the image path
     */
    public String getCSSClass();

    /**
     * Gets the description.
     *
     * @return the description
     */
    public String getDescription();

    /**
     * If change password available
     *
     * @return T or F
     *
     * @exception IdentityManagerException
     */
    public Boolean isChangePasswordAvailable() throws IdentityManagerException;

    /**
     * Exclusive authentication.
     *
     * @return true, if successful
     */
    public boolean isExclusiveAuthentication();

    /**
     * Verify if is local
     *
     * @return T or F
     */
    public Boolean isLocal();

    /**
     * Is recover password available
     *
     * @return T of F
     *
     * @exception IdentityManagerException
     */
    public Boolean isRecoverPasswordAvailable() throws IdentityManagerException;

    /**
     * Is registration available
     *
     * @return T or F
     */
    public Boolean isRegistrationAvailable();
}
