package pt.digitalis.dif.features;

import java.util.Map;

/**
 * Alternative authentication features.
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created May 8, 2019
 */
public interface IDIFFeatureDocManagementIntegration extends IDIFFeature
{

    /**
     * End process.
     */
    public void endProcess();

    /**
     * Gets the id.
     *
     * @return the provider id
     */
    public String getId();

    /**
     * Gets the process.
     *
     * @return the process
     */
    public Map<String, String> getProcess();

    /**
     * Initialize process.
     */
    public void initializeProcess();

    /**
     * Send document.
     *
     * @param document the document
     * @param metadata the metadata
     */
    public void sendDocument(byte[] document, Map<String, String> metadata);
}
