/**
 * 2018, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.flightrecorder;

import org.apache.commons.collections4.queue.CircularFifoQueue;
import pt.digitalis.utils.common.StringUtils;

import java.util.Map;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Aug 20, 2019
 */
public class CircularFifoQueueForFlightRecordings extends CircularFifoQueue<RecorderEntry>
{

    /** The Constant RECORDER_QUEUE_SIZE. */
    private static final int _RECORDER_QUEUE_SIZE = 10000;

    /**
     *
     */
    private static final long serialVersionUID = 2735025807153936008L;

    /**
     *
     */
    public CircularFifoQueueForFlightRecordings()
    {
        super(_RECORDER_QUEUE_SIZE);
    }

    /**
     * @see org.apache.commons.collections4.queue.CircularFifoQueue#remove()
     */
    @Override
    public RecorderEntry remove()
    {
        RecorderEntry entry = super.remove();
        String sessionID = entry.getSessionID();

        if (StringUtils.isNotBlank(sessionID))
        {

            Map<Long, RecorderEntry> sessionEntries = FlightRecorder.indexRecordingBySessionID.get(sessionID);

            if (sessionEntries != null)
                sessionEntries.remove(entry.getId());
        }

        FlightRecorder.indexRecordingByID.remove(entry.getId());

        return entry;
    }
}
