/**
 * 2018, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.flightrecorder;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigLOVValues;
import pt.digitalis.utils.config.annotations.ConfigPrivate;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigVirtualPathForNode;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Jul 31, 2019
 */
@ConfigID("dif2")
@ConfigSectionID("logs/FlightRecorder")
@ConfigVirtualPathForNode("dif2/Logs/Flight recorder")
@ConfigPrivate
public class FlightRecorderConfiguration
{

    /** instance property */
    private static FlightRecorderConfiguration instance;

    /** The active. */
    private Boolean active;

    /** The log level to keep. */
    private String logLevelToKeep;

    /** The log level to keep converted. */
    private LogLevel logLevelToKeepConverted;

    /** The record request longuer than. */
    private Long recordRequestLonguerThan;

    /** The record requests with exceptions. */
    private Boolean recordRequestsWithExceptions;

    /** The record requests with SQL errors. */
    private Boolean recordRequestsWithSQLErrors;

    /**
     * Returns the active configuration object instance.
     *
     * @return the configuration instance
     */
    @ConfigIgnore
    static public FlightRecorderConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                boolean wasSuspended = FlightRecorder.isSuspended();

                if (!wasSuspended)
                    FlightRecorder.suspend();

                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(FlightRecorderConfiguration.class);

                if (!wasSuspended)
                    FlightRecorder.startup();
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /**
     * Inspector for the 'active' attribute.
     *
     * @return the active value
     */
    @ConfigDefault("false")
    public Boolean getActive()
    {
        return active;
    }

    /**
     * Modifier for the 'active' attribute.
     *
     * @param active the new active value to set
     */
    public void setActive(Boolean active)
    {
        this.active = active;
    }

    /**
     * Gets the log level to keep.
     *
     * @return the log level to keep
     */
    @ConfigIgnore
    public LogLevel getLogLevelObjToKeep()
    {
        if (this.logLevelToKeepConverted == null)
            this.logLevelToKeepConverted = LogLevel.valueOf(logLevelToKeep);

        return this.logLevelToKeepConverted;
    }

    /**
     * Inspector for the 'logLevelToKeep' attribute.
     *
     * @return the logLevelToKeep value
     */
    @ConfigLOVValues("FATAL=FATAL,ERROR=ERROR,INFO=INFO,WARN=WARN,DEBUG=DEBUG,TRACE=TRACE")
    @ConfigDefault("DEBUG")
    public String getLogLevelToKeep()
    {
        return logLevelToKeep;
    }

    /**
     * Modifier for the 'logLevelToKeep' attribute.
     *
     * @param logLevelToKeep the new logLevelToKeep value to set
     */
    public void setLogLevelToKeep(String logLevelToKeep)
    {
        this.logLevelToKeep = logLevelToKeep;
        this.logLevelToKeepConverted = LogLevel.valueOf(logLevelToKeep);
    }

    /**
     * Inspector for the 'recordRequestLonguerThan' attribute.
     *
     * @return the recordRequestLonguerThan value
     */
    @ConfigDefault("0")
    public Long getRecordRequestLonguerThan()
    {
        return recordRequestLonguerThan;
    }

    /**
     * Modifier for the 'recordRequestLonguerThan' attribute.
     *
     * @param recordRequestLonguerThan the new recordRequestLonguerThan value to set
     */
    public void setRecordRequestLonguerThan(Long recordRequestLonguerThan)
    {
        this.recordRequestLonguerThan = recordRequestLonguerThan;
    }

    /**
     * Inspector for the 'recordRequestsWithExceptions' attribute.
     *
     * @return the recordRequestsWithExceptions value
     */
    @ConfigDefault("false")
    public Boolean getRecordRequestsWithExceptions()
    {
        return recordRequestsWithExceptions;
    }

    /**
     * Modifier for the 'recordRequestsWithExceptions' attribute.
     *
     * @param recordRequestsWithExceptions the new recordRequestsWithExceptions value to set
     */
    public void setRecordRequestsWithExceptions(Boolean recordRequestsWithExceptions)
    {
        this.recordRequestsWithExceptions = recordRequestsWithExceptions;
    }

    /**
     * Inspector for the 'recordRequestsWithSQLErrors' attribute.
     *
     * @return the recordRequestsWithSQLErrors value
     */
    @ConfigDefault("false")
    public Boolean getRecordRequestsWithSQLErrors()
    {
        return recordRequestsWithSQLErrors;
    }

    /**
     * Modifier for the 'recordRequestsWithSQLErrors' attribute.
     *
     * @param recordRequestsWithSQLErrors the new recordRequestsWithSQLErrors value to set
     */
    public void setRecordRequestsWithSQLErrors(Boolean recordRequestsWithSQLErrors)
    {
        this.recordRequestsWithSQLErrors = recordRequestsWithSQLErrors;
    }
}
