/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.ioc;

import pt.digitalis.dif.codegen.util.ClassEnhancerImpl;
import pt.digitalis.dif.codegen.util.IClassEnhancer;
import pt.digitalis.dif.controller.sanitycheck.GeneralCheckUp;
import pt.digitalis.dif.dem.config.DEMRegistratorImpl;
import pt.digitalis.dif.dem.config.IDEMRegistrator;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.managers.IParameterManager;
import pt.digitalis.dif.dem.managers.IRegistrationManager;
import pt.digitalis.dif.dem.managers.ITemplateManager;
import pt.digitalis.dif.dem.managers.impl.DEMManagerImpl;
import pt.digitalis.dif.dem.managers.impl.MessageManagerImpl;
import pt.digitalis.dif.dem.managers.impl.ParameterManagerImpl;
import pt.digitalis.dif.dem.managers.impl.RegistrationManagerImpl;
import pt.digitalis.dif.dem.managers.impl.TemplateManagerStaticImpl;
import pt.digitalis.dif.dem.objects.ILicense;
import pt.digitalis.dif.dem.objects.LicenseImpl;
import pt.digitalis.dif.sanitycheck.ISanityCheckTestSuite;
import pt.digitalis.dif.servermanager.IServerManager;
import pt.digitalis.dif.servermanager.IServerManagerCommunicator;
import pt.digitalis.dif.servermanager.ServerManagerCommunicatorDefaultImpl;
import pt.digitalis.dif.servermanager.ServerManagerDefaultImpl;
import pt.digitalis.dif.servermanager.messages.AbstractServerMessage;
import pt.digitalis.dif.servermanager.messages.IServerMessage;
import pt.digitalis.dif.servermanager.messages.ServerMessageRefreshConfigurations;
import pt.digitalis.dif.servermanager.messages.ServerMessageRefreshMessages;
import pt.digitalis.dif.servermanager.messages.ServerMessageTypeID;
import pt.digitalis.dif.startup.IStartupCheck;
import pt.digitalis.dif.startup.checks.StartupCheckJavaVersion;
import pt.digitalis.dif.utils.logging.ErrorLogManagerDIFLoggerImpl;
import pt.digitalis.dif.utils.logging.IErrorLogManager;
import pt.digitalis.dif.utils.mail.DIFMailActionLoggerImpl;
import pt.digitalis.dif.utils.mail.IMailActionBuilder;
import pt.digitalis.dif.utils.mail.IMailActionLogger;
import pt.digitalis.dif.utils.mail.sanitycheck.CheckMail;
import pt.digitalis.utils.config.ConfigurationsPreferencesImpl;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;
import pt.digitalis.utils.pools.impl.workers.IPoolWorkerInterceptor;

/**
 * Core Module of the DIF Framework. All services that support the core functionality are declared in this Module
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Oct 2, 2007
 */
public class DIFCoreModule implements IIoCModule
{

    /**
     * Bind server message.
     *
     * @param binder the binder
     * @param clazz  the clazz
     */
    private void bindServerMessage(IoCBinder binder, Class<? extends AbstractServerMessage> clazz)
    {
        binder.bind(IServerMessage.class, clazz).withId(clazz.getAnnotation(ServerMessageTypeID.class).value());
    }

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    @Override
    public void configure(IoCBinder binder)
    {

        // Code Generation Services
        binder.bind(IClassEnhancer.class, ClassEnhancerImpl.class).asSingleton();
        binder.bind(IDEMRegistrator.class, DEMRegistratorImpl.class).asSingleton();

        // DEM Managers
        binder.bind(IDEMManager.class, DEMManagerImpl.class).asSingleton();
        binder.bind(IRegistrationManager.class, RegistrationManagerImpl.class).asSingleton();
        binder.bind(IMessageManager.class, MessageManagerImpl.class).withId("static").asSingleton();
        binder.bind(IParameterManager.class, ParameterManagerImpl.class).asSingleton();

        // Core functionalities
        binder.bind(IConfigurations.class, ConfigurationsPreferencesImpl.class).withId("preferences").asSingleton();
        binder.bind(IServerManagerCommunicator.class, ServerManagerCommunicatorDefaultImpl.class).asSingleton();
        binder.bind(IServerManager.class, ServerManagerDefaultImpl.class).asSingleton();

        // Utilities
        binder.bind(ILicense.class, LicenseImpl.class);
        binder.bind(IErrorLogManager.class, ErrorLogManagerDIFLoggerImpl.class).asSingleton();
        binder.bind(IMailActionLogger.class, DIFMailActionLoggerImpl.class)
                .withId(IMailActionLogger.class.getSimpleName());
        binder.bind(IMailActionBuilder.class, DIFMailActionLoggerImpl.class);

        // Other Modules...
        binder.install(new ControllerModule());
        binder.install(new StaticSecurityModule());
        binder.install(new ParametersModule());
        binder.install(new DIFCoreSanityCheckModule());

        // Custom selected modules
        binder.install(new DefaultModulesSeleccionModule());

        // Server manager sync messages
        bindServerMessage(binder, ServerMessageRefreshMessages.class);
        bindServerMessage(binder, ServerMessageRefreshConfigurations.class);

        // Sanity checks
        binder.bind(ISanityCheckTestSuite.class, CheckMail.class).withId("SanityCheckMail");
        binder.bind(ISanityCheckTestSuite.class, GeneralCheckUp.class).withId("SanityCheckGeneral");

        binder.bind(IPoolWorkerInterceptor.class, DIFPoolWorkerInterceptor.class)
                .withId(DIFPoolWorkerInterceptor.class.getSimpleName());

        // Startup checks
        binder.bind(IStartupCheck.class, StartupCheckJavaVersion.class)
                .withId(StartupCheckJavaVersion.class.getSimpleName());

        // Template manager
        binder.bind(ITemplateManager.class, TemplateManagerStaticImpl.class).asSingleton();
    }
}
