/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.ioc;

import pt.digitalis.dif.controller.security.managers.IAuthenticationManager;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.controller.security.managers.impl.AuthenticationManagerStaticImpl;
import pt.digitalis.dif.controller.security.managers.impl.AuthorizationManagerStaticImpl;
import pt.digitalis.dif.controller.security.managers.impl.IdentityManagerStaticImpl;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.managers.impl.MessageManagerImpl;
import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.utils.config.ConfigurationsPreferencesImpl;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.ioc.IIoCRegistry;
import pt.digitalis.utils.ioc.modules.IoCBinding;
import pt.digitalis.utils.ioc.modules.IoCBindingManager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

/**
 * Wraps a {@link IIoCRegistry} instance, adding the default/active module configuration funcionality for
 * multi-implementations interfaces
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 3 de Fev de 2011
 */
public class DIFDefaultModulesConfiguration
{

    /**
     *
     */
    public static final String DEFAULT_MODULE_CONFIG_ID = "dif2";

    /**
     *
     */
    public static final String DEFAULT_MODULE_CONFIG_SECTION_ID = "Modules";

    /** the singleton instance */
    private static DIFDefaultModulesConfiguration instance = null;

    /**
     * default DIF modules, when no configuration was specified.<br/>
     * Map composed of k = interfaceClassCanonicalName; v = default implementation ID
     */
    private Map<String, String> defaultInnerDIFModuleDefaults = null;

    /** the default modules map cache object, after initialization. */
    private Map<String, String> defaultModuleMap = null;

    /**
     * the default constructor
     */
    public DIFDefaultModulesConfiguration()
    {
    }

    /**
     * @return the singleton instance
     */
    public static DIFDefaultModulesConfiguration getInstance()
    {
        if (instance == null)
            instance = new DIFDefaultModulesConfiguration();

        return instance;
    }

    /**
     * Adds the default implementation from the implementation list. Used when no configurations exists
     *
     * @param interfaceClass
     * @param defaultImplClass
     */
    private void addDefaultIfAvailable(Class<?> interfaceClass, Class<?> defaultImplClass)
    {
        List<IoCBinding> bindings = IoCBindingManager.getInstance().getBindings(interfaceClass);
        String implClassID = null;

        for (IoCBinding binding : bindings)
        {
            if (binding.getImplementationType() == defaultImplClass)
            {
                implClassID = binding.getId();
                break;
            }
        }

        if (implClassID != null)
            defaultInnerDIFModuleDefaults.put(interfaceClass.getCanonicalName(), implClassID);
    }

    /**
     * Adds to the default implementations list used when no configurations exists, the first implementation that is not
     * the defaultImplClass, or defaultImplClass if it is the only one
     *
     * @param interfaceClass
     * @param defaultImplClass
     */
    private void addOtherThanDefaultIfAvailable(Class<?> interfaceClass, Class<?> defaultImplClass)
    {
        List<IoCBinding> bindings = IoCBindingManager.getInstance().getBindings(interfaceClass);
        String implClassID = null;

        for (IoCBinding binding : bindings)
        {
            if (implClassID == null || binding.getImplementationType() != defaultImplClass)
                implClassID = binding.getId();
        }

        defaultInnerDIFModuleDefaults.put(interfaceClass.getCanonicalName(), implClassID);
    }

    /**
     * @param serviceInterface the serviceInterfase
     *
     * @return the Id of the default implementation as customized. Will use the hard-coded defaults if no custom
     *         configuration exists
     */
    public IoCBinding getDefaultImplementationBindingFor(Class<?> serviceInterface)
    {
        return IoCBindingManager.getInstance()
                .getBinding(serviceInterface, getDefaultImplementationIDFor(serviceInterface));
    }

    /**
     * @param serviceInterface the serviceInterfase
     *
     * @return the Id of the default implementation as customized. Will use the hard-coded defaults if no custom
     *         configuration exists
     */
    public String getDefaultImplementationIDFor(Class<?> serviceInterface)
    {
        if (defaultModuleMap == null)
        {
            defaultModuleMap = new HashMap<String, String>();

            // load customized configurations
            Properties customDefaultModules = DIFStartupConfiguration.getModulesProps();

            for (Entry<Object, Object> entry : customDefaultModules.entrySet())
            {
                defaultModuleMap.put(entry.getKey().toString(), entry.getValue().toString());
            }

            // for DIF main modules, add missing configurations from defaults
            for (Entry<String, String> entry : getDefaultInnerDIFModuleDefaults().entrySet())
            {
                if (!defaultModuleMap.containsKey(entry.getKey()))
                    defaultModuleMap.put(entry.getKey(), entry.getValue());
            }
        }

        return defaultModuleMap.get(serviceInterface.getCanonicalName());
    }

    /**
     * Inspector for the 'defaultInnerDIFModuleDefaults' attribute.
     *
     * @return the defaultInnerDIFModuleDefaults value
     */
    protected Map<String, String> getDefaultInnerDIFModuleDefaults()
    {
        if (defaultInnerDIFModuleDefaults == null)
        {
            defaultInnerDIFModuleDefaults = new HashMap<String, String>();

            // Always add the static implementation AS THE DEFAULT.
            // Customization will take priority if exists
            // TODO: Luis: Add these contributions that do not have implementations in the Core module.
            // TODO: Luis: Must add to the configurations persistence the selected module, for future backwards
            // compatibility
            // addDefaultIfAvailable(IContentManager.class, null);
            // addDefaultIfAvailable(IDocumentRepositoryManager.class, null);
            addDefaultIfAvailable(IMessageManager.class, MessageManagerImpl.class);
            addDefaultIfAvailable(IAuthorizationManager.class, AuthorizationManagerStaticImpl.class);

            // Configurations can only use DB implementation if configuration is available
            if (DIFStartupConfiguration.getBootstrapMode())
            {
                // In bootstrap mode force the integration modules off
                addDefaultIfAvailable(IIdentityManager.class, IdentityManagerStaticImpl.class);
                addDefaultIfAvailable(IAuthenticationManager.class, AuthenticationManagerStaticImpl.class);
                addDefaultIfAvailable(IConfigurations.class, ConfigurationsPreferencesImpl.class);
            }
            else
            {
                // Add "other" implementation than the static if present AS THE DEFAULT.
                // Customization will take priority if exists
                addOtherThanDefaultIfAvailable(IIdentityManager.class, IdentityManagerStaticImpl.class);
                addOtherThanDefaultIfAvailable(IAuthenticationManager.class, AuthenticationManagerStaticImpl.class);
                addOtherThanDefaultIfAvailable(IConfigurations.class, ConfigurationsPreferencesImpl.class);
            }
        }

        return defaultInnerDIFModuleDefaults;
    }
}
