/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.ioc;

import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.utils.config.ConfigurationsProvider;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.ioc.IIoCRegistry;
import pt.digitalis.utils.ioc.IoCImplementations;
import pt.digitalis.utils.ioc.exception.IoCException;
import pt.digitalis.utils.ioc.guice.IoCRegistryGuiceImpl;

/**
 * This class represents a wrapper class for the real registry implementation. Since we cant use IoC to abstract us from
 * the IoC implementation we wish to use, we will use this Facade class to get to the real implementation. The registry
 * is created with the proper implementation according to the default core dif configuration.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Oct 2, 2007
 */
final public class DIFIoCRegistry
{

    /** IIoCRegistry instance */
    private static IIoCRegistry instance;

    /**
     * Enforce noninstantiability
     */
    private DIFIoCRegistry()
    {
    }

    /**
     * Getter for the Singleton instance of {@link IIoCRegistry}
     *
     * @return the registry instance
     */
    static public IIoCRegistry getRegistry()
    {
        if (instance == null)
            if (IoCImplementations.GUICE.equals(DIFStartupConfiguration.getIoCImplementation()))
            {
                try
                {
                    instance = IoCRegistryGuiceImpl.getRegistry(DIFStartupConfiguration.getModuleParser());

                    // Must set this as early as possible to override the fixed configurations API set in the
                    // ConfigurationUtils
                    ConfigurationsProvider.setConfigurations(instance.getImplementation(IConfigurations.class));
                }
                catch (IoCException iocException)
                {
                    throw new RuntimeException("Could not find a valid IoC registry! Unable to proceed...",
                            iocException);
                }
            }
            else
                throw new RuntimeException(
                        "Unsupported IoC: \"" + DIFStartupConfiguration.getIoCImplementation() + "\"\n" +
                        "Check DIF configuration.");

        return instance;
    }
}
