package pt.digitalis.dif.ioc;

import pt.digitalis.dif.utils.logging.AuditContext;
import pt.digitalis.utils.pools.impl.workers.IPoolWorkerInterceptor;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Mar 18, 2016
 */
public class DIFPoolWorkerInterceptor implements IPoolWorkerInterceptor
{

    /**
     * @see pt.digitalis.utils.pools.impl.workers.IPoolWorkerInterceptor#onRun()
     */
    public void onRun()
    {
        if (AuditContext.getProcessNameForCurrentThread() == null)
        {
            AuditContext.setProcessNameForCurrentThread("Job:" + this.getClass().getSimpleName());
        }
        if (AuditContext.getUserForCurrentThread() == null)
        {
            AuditContext.setUserForCurrentThread("DIF");
        }
    }
}
