/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.model.utils;

import pt.digitalis.utils.common.BeanInspector;
import pt.digitalis.utils.common.IBeanAttributes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

/**
 * A base implementation of a {@link IBeanAttributes} object
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/09/19
 */
abstract public class AbstractBeanAttributes implements IBeanAttributes
{

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#getAttribute(java.lang.String)
     */
    public Object getAttribute(String attributeName)
    {

        if (attributeName == null)
            return null;

        else if (attributeName.contains("."))
        {
            String[] args = attributeName.split("\\.", 2);

            return BeanInspector.getValue(getAttributeNoGraphNavigation(args[0].trim()), args[1].trim());
        }
        else
            return getAttributeNoGraphNavigation(attributeName);
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#getAttributeAsString(java.lang.String)
     */
    public String getAttributeAsString(String attributeName)
    {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else
            return value.toString().trim();
    }

    /**
     * Returns the bean attribute. This attribute must be a class attribute, without graph navigation for inner class
     * properties
     *
     * @param attributeName the attribute name
     *
     * @return the attribute value
     */
    abstract protected Object getAttributeNoGraphNavigation(String attributeName);

    /**
     * Convert Clob to String
     *
     * @param clob the clob
     *
     * @return descParecer Clob as String
     *
     * @exception SQLException
     * @exception IOException
     */
    public String getClobAsString(java.sql.Clob clob) throws SQLException, IOException
    {
        StringBuilder stringBuffer = new StringBuilder();

        Reader reader = clob.getCharacterStream();
        BufferedReader bufferReader = new BufferedReader(reader);

        int b;
        while (-1 != (b = bufferReader.read()))
        {
            stringBuffer.append((char) b);
        }
        bufferReader.close();

        return stringBuffer.toString();
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setNestedAttribute(java.lang.String, java.lang.Object)
     */
    public void setNestedAttribute(String attributeName, Object attributeValue)
    {
        if (attributeName.contains("."))
            BeanInspector.setNestedAtributeValue(this, attributeName, attributeValue);
        else
            setAttribute(attributeName, attributeValue);
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setNestedAttributeFromString(java.lang.String,
     *         java.lang.String)
     */
    public void setNestedAttributeFromString(String attributeName, String attributeValue)
    {
        if (attributeName.contains("."))
        {

            String remainingAttributeName = attributeName;
            IBeanAttributes currentObj = this;

            while (remainingAttributeName.contains("."))
            {

                int separatorPosition = remainingAttributeName.indexOf(".");
                String currentAttributeName = remainingAttributeName.substring(0, separatorPosition);
                remainingAttributeName = remainingAttributeName.substring(separatorPosition + 1);

                Object obj = currentObj.getAttribute(currentAttributeName);

                if (obj instanceof IBeanAttributes)
                {
                    currentObj = (IBeanAttributes) obj;
                }
                else
                {

                    BeanInspector
                            .setNestedAtributeValue(currentObj, currentAttributeName + "." + remainingAttributeName,
                                    attributeValue);
                    remainingAttributeName = null;
                    break;
                }
            }

            if (remainingAttributeName != null)
                currentObj.setAttributeFromString(remainingAttributeName, attributeValue);
        }
        else
            setAttributeFromString(attributeName, attributeValue);
    }
}
