package pt.digitalis.dif.sanitycheck;

import pt.digitalis.dif.sanitycheck.manager.TestMethodDefinition;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 1 de Jul de 2011
 */
public class TestResult
{

    /** Sanity Result Type */
    ExecutionResult executionResult;

    /** the test error message */
    private String errorMessage;

    /** Sanity Check Unit name */
    private String name;

    /** The test success message */
    private String successMessage;

    /**
     * @param executionResult
     */
    public TestResult(ExecutionResult executionResult)
    {
        this(null, executionResult);
    }

    /**
     * @param testMethod
     * @param executionResult
     */
    public TestResult(TestMethodDefinition testMethod, ExecutionResult executionResult)
    {
        super();
        this.executionResult = executionResult;

        if (testMethod != null)
            setName(testMethod.getName());
    }

    /**
     * Inspector for the 'errorMessage' attribute.
     *
     * @return the errorMessage value
     */
    public String getErrorMessage()
    {
        return errorMessage;
    }

    /**
     * Modifier for the 'errorMessage' attribute.
     *
     * @param errorMessage the new errorMessage value to set
     */
    public void setErrorMessage(String errorMessage)
    {
        this.errorMessage = errorMessage;
    }

    /**
     * Inspector for the 'executionResult' attribute.
     *
     * @return the executionResult value
     */
    public ExecutionResult getExecutionResult()
    {
        return executionResult;
    }

    /**
     * Modifier for the 'executionResult' attribute.
     *
     * @param executionResult the new executionResult value to set
     */
    public void setExecutionResult(ExecutionResult executionResult)
    {
        this.executionResult = executionResult;
    }

    /**
     * Inspector for the 'name' attribute.
     *
     * @return the name value
     */
    public String getName()
    {
        return name;
    }

    /**
     * Modifier for the 'name' attribute.
     *
     * @param name the new name value to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * Inspector for the 'sucessMessage' attribute.
     *
     * @return the sucessMessage value
     */
    public String getSuccessMessage()
    {
        return successMessage;
    }

    /**
     * Modifier for the 'sucessMessage' attribute.
     *
     * @param sucessMessage the new sucessMessage value to set
     */
    public void setSuccessMessage(String sucessMessage)
    {
        this.successMessage = sucessMessage;
    }
}
