/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.sanitycheck.manager;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created May 30, 2014
 */
public class SanityCheckThread extends Thread
{

    /** The Constant SANITY_CHECK_RESULT. */
    public static final String SANITY_CHECK_RESULT = "SANITY_CHECK_RESULT";

    /** The context. */
    private final IDIFContext context;

    /**
     * Instantiates a new sanity check thread.
     *
     * @param context the context
     */
    public SanityCheckThread(IDIFContext context)
    {
        super();
        this.context = context;
    }

    /**
     * @see java.lang.Thread#run()
     */
    @Override
    public void run()
    {
        context.getSession().addAttribute(SANITY_CHECK_RESULT, null);

        boolean result = SanityCheckManager.runAllTests(this.context, true);

        context.getSession().addAttribute(SANITY_CHECK_RESULT, result);

        super.run();
    }
}
