/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

import pt.digitalis.dif.servermanager.messages.IServerMessage;

import java.util.List;

/**
 * The Interface IServerManager.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Apr 23, 2019
 */
public interface IServerManager
{

    /**
     * If this manager allows server communication.
     *
     * @return true, if successful
     */
    public boolean allowServerCommunication();

    /**
     * Apply server name change.
     *
     * @exception ServerManagerException the server manager exception
     */
    public void applyNameChange() throws ServerManagerException;

    /**
     * Discovers the servers running on the managing infrastructure.
     *
     * @exception ServerManagerException the server manager exception
     */
    public void discoverServers() throws ServerManagerException;

    /**
     * Gets the all apps running on all registered servers instance.
     *
     * @return the apps running
     *
     * @exception ServerManagerException the server manager exception
     */
    public List<ServerApplicationNodeInstance> getAllServers() throws ServerManagerException;

    /**
     * Gets the apps running on this server instance.
     *
     * @return the apps running on this server instance
     *
     * @exception ServerManagerException the server manager exception
     */
    public List<ServerApplicationNodeInstance> getAppsRunningOnThisServerInstance() throws ServerManagerException;

    /**
     * Gets the current server communication port.
     *
     * @return the current server communication port
     *
     * @exception ServerManagerException the server manager exception
     */
    public String getCurrentServerCommunicationPort() throws ServerManagerException;

    /**
     * Gets the server instances running running this app.
     *
     * @return the apps running on this server instance
     *
     * @exception ServerManagerException the server manager exception
     */
    public List<ServerApplicationNodeInstance> getOtherInstancesOfThisApp() throws ServerManagerException;

    /**
     * Gets the server node.
     *
     * @return the serverNode
     */
    public ServerApplicationNodeInstance getServerNode();

    /**
     * Initialize the server manager.
     *
     * @exception ServerManagerException the server manager exception
     */
    public void initialize() throws ServerManagerException;

    /**
     * Checks if is valid server IP address.
     *
     * @param callerIP the caller IP
     *
     * @return true, if is valid server IP address
     */
    public boolean isValidServerIPAddress(String callerIP);

    /**
     * Keep server alive.
     *
     * @exception ServerManagerException the server manager exception
     */
    public void keepServerAlive() throws ServerManagerException;

    /**
     * Process server messages.
     *
     * @exception ServerManagerException the server manager exception
     */
    public void processServerMessages() throws ServerManagerException;

    /**
     * Register the current server on the managing infrastructure.
     *
     * @exception ServerManagerException the server manager exception
     */
    public void registerServer() throws ServerManagerException;

    /**
     * Send message.
     *
     * @param serverMessage the server message to send
     *
     * @return T if the send was successful
     *
     * @exception ServerManagerException the server manager exception
     */
    public boolean sendMessage(IServerMessage serverMessage) throws ServerManagerException;

    /**
     * Update HTTP port.
     *
     * @param portNumberParameter the portNumberParameter number
     *
     * @exception ServerManagerException the server manager exception
     */
    public void updateHTTPPort(Integer portNumberParameter) throws ServerManagerException;
}
