/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

/**
 * Defines the communications skill methods for {@link IServerManager}.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 6, 2019
 */
public interface IServerManagerCommunicator
{

    /**
     * Allows server communication?.
     *
     * @return true, if successful
     */
    public boolean allowServerCommunication();

    /**
     * Gets the current server base URL.
     *
     * @return the current server base URL
     */
    public String getCurrentServerBaseURL();

    /**
     * Gets the current server context root.
     *
     * @return the current server context root
     *
     * @exception ServerManagerException the server manager exception
     */
    public String getCurrentServerContextRoot() throws ServerManagerException;

    /**
     * Gets the current server IP address.
     *
     * @return the current server IP address
     *
     * @exception ServerManagerException
     */
    public String getCurrentServerIPAddress() throws ServerManagerException;

    /**
     * Gets the server URL.
     *
     * @param currentServerIPAddress         the current server IP address
     * @param currentServerCommunicationPort the current server communication port
     * @param currentServerContextRoot       the current server context root
     *
     * @return the server URL
     */
    public String getServerURL(String currentServerIPAddress, String currentServerCommunicationPort,
            String currentServerContextRoot);
}
