/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;
import pt.digitalis.utils.common.DateUtils;

import java.util.Date;
import java.util.List;

/**
 * Identifies another server application instance accessible by the current application.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Apr 24, 2019
 */
public class ServerApplicationNodeInstance implements IObjectFormatter
{

    /**
     * The Startup time.
     */
    private Date startupTime;

    /**
     * The context root ID.
     */
    private String contextRootID;

    /**
     * The machine server app UID.
     */
    private String machineServerUID;

    /**
     * The port.
     */
    private String port;

    /**
     * The server base URL.
     */
    private String serverBaseURL;

    /**
     * The server IP.
     */
    private String serverIP;

    /**
     * The server management object.
     */
    private Object serverManagementObject;

    /**
     * Instantiates a new server application node instance.
     *
     * @param machineServerUID the machine server UID
     * @param serverIP         the server IP
     * @param contextRootID    the context root ID
     * @param port             the port
     * @param serverBaseURL    the server base URL
     */
    public ServerApplicationNodeInstance(String machineServerUID, String serverIP, String contextRootID, String port,
            String serverBaseURL)
    {
        super();
        this.machineServerUID = machineServerUID;
        this.serverIP = serverIP;
        this.contextRootID = contextRootID;
        this.port = port;
        this.serverBaseURL = serverBaseURL;
        this.startupTime = new Date();
    }

    /**
     * Gets the context root ID.
     *
     * @return the contextRootID
     */
    public String getContextRootID()
    {
        return contextRootID;
    }

    /**
     * Gets the machine server UID.
     *
     * @return the machineServerUID
     */
    public String getMachineServerUID()
    {
        return machineServerUID;
    }

    /**
     * Gets the port.
     *
     * @return the port
     */
    public String getPort()
    {
        return port;
    }

    /**
     * Gets the server base URL.
     *
     * @return the serverBaseURL
     */
    public String getServerBaseURL()
    {
        return serverBaseURL;
    }

    /**
     * Gets server ip.
     *
     * @return the serverIP
     */
    public String getServerIP()
    {
        return serverIP;
    }

    /**
     * Gets server management object.
     *
     * @return the serverManagementObject
     */
    public Object getServerManagementObject()
    {
        return serverManagementObject;
    }

    /**
     * Sets server management object.
     *
     * @param serverManagementObject the serverManagementObject to set
     */
    public void setServerManagementObject(Object serverManagementObject)
    {
        this.serverManagementObject = serverManagementObject;
    }

    /**
     * Gets startup time.
     *
     * @return the startup time
     */
    public Date getStartupTime()
    {
        return startupTime;
    }

    /**
     * Sets startup time.
     *
     * @param startupTime the startup time
     */
    public void setStartupTime(Date startupTime)
    {
        this.startupTime = startupTime;
    }

    /**
     * Gets up time.
     *
     * @return the up time
     */
    public String getUpTime()
    {
        return DateUtils.getTimePassedAsFormattedString(new Date().getTime() - this.getStartupTime().getTime());
    }

    @Override
    public ObjectFormatter toObjectFormatter(Format format, List<Object> dumpedObjects)
    {
        ObjectFormatter formatter = new ObjectFormatter(format, dumpedObjects);
        formatter.addItemIfNotNull("contextRootID", contextRootID);
        formatter.addItemIfNotNull("machineServerUID", machineServerUID);
        formatter.addItemIfNotNull("startupTime", startupTime);
        formatter.addItemIfNotNull("port", port);
        formatter.addItemIfNotNull("serverBaseURL", serverBaseURL);
        formatter.addItemIfNotNull("serverIP", serverIP);
        formatter.addItemIfNotNull("serverManagementObject", serverManagementObject);

        return formatter;
    }

    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT, null).getFormatedObject();
    }
}
