/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

import pt.digitalis.dif.ioc.DIFIoCRegistry;

/**
 * The Class ServerManager.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Apr 23, 2019
 */
public class ServerManager
{

    /** The server manager. */
    private static IServerManager serverManager = null;

    /**
     * Gets the single instance of ServerManager.
     *
     * @return single instance of ServerManager
     *
     * @exception ServerManagerException
     */
    public static IServerManager getInstance() throws ServerManagerException
    {
        if (serverManager == null)
        {
            serverManager = DIFIoCRegistry.getRegistry().getImplementation(IServerManager.class);
            serverManager.initialize();
        }

        return serverManager;
    }
}
