/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

/**
 * The Class ServerManagerCommunicatorDefaultImpl.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 6, 2019
 */
public class ServerManagerCommunicatorDefaultImpl implements IServerManagerCommunicator
{

    /**
     * Allow server communication.
     *
     * @return true, if successful
     *
     * @see pt.digitalis.dif.servermanager.IServerManagerCommunicator#allowServerCommunication()
     */
    public boolean allowServerCommunication()
    {
        return false;
    }

    /**
     * Gets the current server base URL.
     *
     * @return the current server base URL
     *
     * @see pt.digitalis.dif.servermanager.IServerManagerCommunicator#getCurrentServerBaseURL()
     */
    public String getCurrentServerBaseURL()
    {
        return "";
    }

    /**
     * Gets the current server context root.
     *
     * @return the current server context root
     *
     * @see pt.digitalis.dif.servermanager.IServerManagerCommunicator#getCurrentServerContextRoot()
     */
    public String getCurrentServerContextRoot()
    {
        return "";
    }

    /**
     * Gets the current server IP address.
     *
     * @return the current server IP address
     *
     * @see pt.digitalis.dif.servermanager.IServerManagerCommunicator#getCurrentServerIPAddress()
     */
    public String getCurrentServerIPAddress()
    {
        return "";
    }

    /**
     * @see pt.digitalis.dif.servermanager.IServerManagerCommunicator#getServerURL(java.lang.String,
     *         java.lang.String,
     *         java.lang.String)
     */
    public String getServerURL(String currentServerIPAddress, String currentServerCommunicationPort,
            String currentServerContextRoot)
    {
        return "";
    }
}
