/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigPrivate;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

// TODO: Auto-generated Javadoc

/**
 * The Class ServerManagerConfigurations.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Apr 24, 2019
 */
@ConfigID("dif2")
@ConfigSectionID("ServerSync")
public class ServerManagerConfigurations
{

    /** The singleton instance property. */
    private static ServerManagerConfigurations instance;

    /** The refresh servers after minutes. */
    private Long previousCommunicationPort;

    /** The purge inactive server after minutes. */
    private Long purgeInactiveServerAfterMinutes;

    /** The purge messages after months. */
    private Long purgeMessagesAfterMonths;

    /** The refresh servers after minutes. */
    private Long refreshServersAfterMinutes;

    /** The server custom name. */
    private String serverCustomName;

    /** The server URL for server to server sync. */
    private String serverURLForServerToServerSync;

    /**
     * Returns the active configuration object instance.
     *
     * @return the configuration instance
     *
     * @exception ConfigurationException the exception
     */
    @ConfigIgnore
    static public ServerManagerConfigurations getInstance() throws ConfigurationException
    {
        if (instance == null)
        {
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(ServerManagerConfigurations.class);
            }
            catch (ConfigurationException e)
            {
                e.printStackTrace();
                instance = null;
            }
        }

        return instance;
    }

    /**
     * Gets the previous communication port.
     *
     * @return the previousCommunicationPort
     */
    @ConfigPrivate
    public Long getPreviousCommunicationPort()
    {
        return previousCommunicationPort;
    }

    /**
     * Sets the previous communication port.
     *
     * @param previousCommunicationPort the previousCommunicationPort to set
     */
    public void setPreviousCommunicationPort(Long previousCommunicationPort)
    {
        this.previousCommunicationPort = previousCommunicationPort;
    }

    /**
     * Gets the purge inactive server after minutes.
     *
     * @return the purgeInactiveServerAfterMinutes
     */
    @ConfigDefault("30")
    public Long getPurgeInactiveServerAfterMinutes()
    {
        return purgeInactiveServerAfterMinutes;
    }

    /**
     * Sets the purge inactive server after minutes.
     *
     * @param purgeInactiveServerAfterMinutes the purgeInactiveServerAfterMinutes to set
     */
    public void setPurgeInactiveServerAfterMinutes(Long purgeInactiveServerAfterMinutes)
    {
        this.purgeInactiveServerAfterMinutes = purgeInactiveServerAfterMinutes;
    }

    /**
     * @return the purgeMessagesAfterMonths
     */
    @ConfigDefault("3")
    public Long getPurgeMessagesAfterMonths()
    {
        return purgeMessagesAfterMonths;
    }

    /**
     * @param purgeMessagesAfterMonths the purgeMessagesAfterMonths to set
     */
    public void setPurgeMessagesAfterMonths(Long purgeMessagesAfterMonths)
    {
        this.purgeMessagesAfterMonths = purgeMessagesAfterMonths;
    }

    /**
     * Gets the refresh servers after minutes.
     *
     * @return the refreshServersAfterMinutes
     */
    @ConfigDefault("5")
    public Long getRefreshServersAfterMinutes()
    {
        return refreshServersAfterMinutes;
    }

    /**
     * Sets the refresh servers after minutes.
     *
     * @param refreshServersAfterMinutes the refreshServersAfterMinutes to set
     */
    public void setRefreshServersAfterMinutes(Long refreshServersAfterMinutes)
    {
        this.refreshServersAfterMinutes = refreshServersAfterMinutes;
    }

    /**
     * Gets the server custom name.
     *
     * @return the serverCustomName
     */
    public String getServerCustomName()
    {
        return serverCustomName;
    }

    /**
     * Sets the server custom name.
     *
     * @param serverCustomName the serverCustomName to set
     */
    public void setServerCustomName(String serverCustomName)
    {
        this.serverCustomName = serverCustomName;
    }

    /**
     * Gets the server URL for server to server sync.
     *
     * @return the serverURLForServerToServerSync
     */
    public String getServerURLForServerToServerSync()
    {
        return serverURLForServerToServerSync;
    }

    /**
     * Sets the server URL for server to server sync.
     *
     * @param serverURLForServerToServerSync the serverURLForServerToServerSync to set
     */
    public void setServerURLForServerToServerSync(String serverURLForServerToServerSync)
    {
        this.serverURLForServerToServerSync = serverURLForServerToServerSync;
    }
}
