/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

import pt.digitalis.dif.servermanager.messages.IServerMessage;

import java.util.ArrayList;
import java.util.List;

// TODO: Auto-generated Javadoc

/**
 * Void implementation. If no other is provided server messages will not be possible.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Apr 23, 2019
 */
public class ServerManagerDefaultImpl extends AbstractServerManager implements IServerManager
{

    /**
     * Allow server communication.
     *
     * @return true, if successful
     *
     * @see pt.digitalis.dif.servermanager.IServerManager#allowServerCommunication()
     */
    public boolean allowServerCommunication()
    {
        return false;
    }

    /**
     * Apply name change.
     *
     * @exception ServerManagerException the server manager exception
     * @see pt.digitalis.dif.servermanager.IServerManager#applyNameChange()
     */
    public void applyNameChange() throws ServerManagerException
    {
        // Null implementation
    }

    /**
     * Discover servers.
     *
     * @see pt.digitalis.dif.servermanager.IServerManager#discoverServers()
     */
    public void discoverServers()
    {
        // Null implementation
    }

    /**
     * Gets the all servers.
     *
     * @return the all servers
     *
     * @exception ServerManagerException the server manager exception
     * @see pt.digitalis.dif.servermanager.IServerManager#getAllServers()
     */
    public List<ServerApplicationNodeInstance> getAllServers() throws ServerManagerException
    {
        return new ArrayList<ServerApplicationNodeInstance>();
    }

    /**
     * Internal initialize.
     *
     * @see pt.digitalis.dif.servermanager.AbstractServerManager#internalInitialize()
     */
    @Override
    void internalInitialize()
    {
        // Null implementation
    }

    /**
     * @see pt.digitalis.dif.servermanager.IServerManager#isValidServerIPAddress(java.lang.String)
     */
    public boolean isValidServerIPAddress(String callerIP)
    {
        // Null implementation
        return false;
    }

    /**
     * Keep server alive.
     *
     * @exception ServerManagerException the server manager exception
     * @see pt.digitalis.dif.servermanager.IServerManager#keepServerAlive()
     */
    public void keepServerAlive() throws ServerManagerException
    {
        // Null implementation
    }

    /**
     * Migrate messages between server entries.
     *
     * @param previousServerNode  the previous server node
     * @param newServerNode       the new server node
     * @param onlyPendingMessages the only pending messages
     *
     * @see pt.digitalis.dif.servermanager.AbstractServerManager#migrateMessagesBetweenServerEntries(pt.digitalis.dif.servermanager.ServerApplicationNodeInstance,
     *         pt.digitalis.dif.servermanager.ServerApplicationNodeInstance, boolean)
     */
    @Override
    protected void migrateMessagesBetweenServerEntries(ServerApplicationNodeInstance previousServerNode,
            ServerApplicationNodeInstance newServerNode, boolean onlyPendingMessages)
    {
        // Null implementation
    }

    /**
     * Process server messages.
     *
     * @exception ServerManagerException the server manager exception
     * @see pt.digitalis.dif.servermanager.IServerManager#processServerMessages()
     */
    public void processServerMessages() throws ServerManagerException
    {
        // Null implementation
    }

    /**
     * Register server.
     *
     * @see pt.digitalis.dif.servermanager.IServerManager#registerServer()
     */
    public void registerServer()
    {
        // Null implementation
    }

    /**
     * Send message.
     *
     * @param serverMessage the server message
     *
     * @return true, if successful
     *
     * @see pt.digitalis.dif.servermanager.IServerManager#sendMessage(pt.digitalis.dif.servermanager.messages.IServerMessage)
     */
    public boolean sendMessage(IServerMessage serverMessage)
    {
        // Null implementation
        return false;
    }
}
