/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

import pt.digitalis.utils.common.DateUtils;
import pt.digitalis.utils.crypto.exeption.CryptoException;
import pt.digitalis.utils.crypto.impl.EncryptorBase64Impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 20, 2019
 */
public class ServerManagerUtils
{

    /** The encriptor. */
    private static EncryptorBase64Impl encriptor = null;

    /**
     * Decrypt value.
     *
     * @param encriptedValue the encripted value
     *
     * @return the string
     *
     * @exception ServerManagerException
     * @exception CryptoException
     */
    public static String decryptValue(String encriptedValue) throws ServerManagerException, CryptoException
    {
        EncryptorBase64Impl encriptor = getEncriptor();
        DateFormat df = new SimpleDateFormat(DateUtils.SIMPLE_DATE_FORMAT_TIME);

        String decriptedServerURL = encriptor.decrypt(encriptedValue);
        String[] portions = decriptedServerURL.split("\\|\\|\\|");

        if (portions.length != 2)
        {
            throw new ServerManagerException("Parameter is invalid. Security check on decription failed!");
        }
        else
        {
            String datePortion = portions[0];
            String valuePortion = portions[1];

            // Validate the date as a valid date
            try
            {
                df.parse(datePortion);

                // Date parse OK, return value
                return valuePortion;
            }
            catch (ParseException e)
            {
                throw new ServerManagerException("Parameter is invalid. Security check on decription failed!", e);
            }
        }
    }

    /**
     * Gets the encriptor.
     *
     * @return the encriptor
     */
    private static EncryptorBase64Impl getEncriptor()
    {
        if (encriptor == null)
        {
            encriptor = new EncryptorBase64Impl();
            encriptor.setSeed("This#$ISaCV#Server00Manager1@Seed");
        }

        return encriptor;
    }

    /**
     * Gets the encrypted key.
     *
     * @param value the value
     *
     * @return the encrypted key
     *
     * @exception CryptoException
     */
    public static String encryptValue(String value) throws CryptoException
    {
        // Create an key to pass in serverURL with the current date and the serverURL
        DateFormat df = new SimpleDateFormat(DateUtils.SIMPLE_DATE_FORMAT_TIME);
        String valueToEncrypt = df.format(new Date()) + "|||" + value;

        // Encrypt the parameter for safety
        EncryptorBase64Impl encriptor = getEncriptor();

        return encriptor.encrypt(valueToEncrypt);
    }
}
