/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * The result of a server message execution.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 10, 2019
 */
public class ServerMessageExecutionResult
{

    /** The error. */
    private Exception error;

    /** The result. */
    private String result;

    /** The success. */
    private boolean success;

    /**
     * Instantiates a new server message execution result.
     *
     * @param success the success
     */
    public ServerMessageExecutionResult(boolean success)
    {
        super();
        this.success = success;
    }

    /**
     * Instantiates a new server message execution result.
     *
     * @param success the success
     * @param result  the result
     */
    public ServerMessageExecutionResult(boolean success, String result)
    {
        super();
        this.success = success;
        this.result = result;
    }

    /**
     * Instantiates a new server message execution result.
     *
     * @param error the error
     */
    public ServerMessageExecutionResult(Exception error)
    {
        super();
        this.error = error;
    }

    /**
     * Instantiates a new server message execution result.
     *
     * @param result the result
     * @param error  the error
     */
    public ServerMessageExecutionResult(String result, Exception error)
    {
        super();
        this.result = result;
        this.error = error;
    }

    /**
     * Gets the error.
     *
     * @return the error
     */
    public Exception getError()
    {
        return error;
    }

    /**
     * Sets the error.
     *
     * @param error the error to set
     */
    public void setError(Exception error)
    {
        this.error = error;
    }

    /**
     * Gets the result.
     *
     * @return the result
     */
    public String getResult()
    {
        return result;
    }

    /**
     * Sets the result.
     *
     * @param result the result to set
     */
    public void setResult(String result)
    {
        this.result = result;
    }

    /**
     * Checks if is success.
     *
     * @return the success
     */
    public boolean isSuccess()
    {
        return success;
    }

    /**
     * Sets the success.
     *
     * @param success the success to set
     */
    public void setSuccess(boolean success)
    {
        this.success = success;
    }

    /**
     * Gets the result string. A combination of all
     *
     * @return the result string
     *
     * @exception JsonProcessingException
     */
    public String toJSONString() throws JsonProcessingException
    {
        ObjectMapper mapper = new ObjectMapper();
        String asJSONString = mapper.writeValueAsString(this);

        return asJSONString;
    }
}
