/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager.jobs;

import pt.digitalis.dif.servermanager.IServerManager;
import pt.digitalis.dif.utils.jobs.RecurrentJob;
import pt.digitalis.utils.config.ConfigurationException;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 3, 2019
 */
public class KeepServerAliveJob extends RecurrentJob
{

    /** The server manager. */
    private IServerManager serverManager;

    /**
     * @param serverManager
     */
    public KeepServerAliveJob(IServerManager serverManager)
    {
        super();
        this.serverManager = serverManager;
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#executeEachTime()
     */
    @Override
    protected boolean executeEachTime() throws Exception
    {
        serverManager.keepServerAlive();

        return true;
    }

    /**
     * @see pt.digitalis.dif.utils.jobs.DIFJob#getDefaultRunIntervalInSeconds()
     */
    @Override
    protected Long getDefaultRunIntervalInSeconds() throws ConfigurationException
    {
        return 120L;
    }
}
