/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager.messages;

import org.json.JSONObject;

/**
 * The Class AbstractServerMessage.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 10, 2019
 */
public abstract class AbstractServerMessage implements IServerMessage
{

    /** The sender server ID. */
    private String messageTypeID = null;

    /** The sender server ID. */
    private Long senderServerID;

    /**
     * Instantiates a new abstract server message.
     */
    public AbstractServerMessage()
    {
        super();
    }

    /**
     * Gets the message type ID.
     *
     * @return the message type ID
     *
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#getMessageTypeID()
     */
    public String getMessageTypeID()
    {
        if (messageTypeID == null)
        {
            ServerMessageTypeID annotation = this.getClass().getAnnotation(ServerMessageTypeID.class);

            if (annotation == null)
                throw new RuntimeException("Class " + this.getClass().getCanonicalName() + " must have the " +
                                           ServerMessageTypeID.class.getSimpleName() + " annotation!");
            else
                messageTypeID = annotation.value();
        }

        return messageTypeID;
    }

    /**
     * Gets the sender server ID.
     *
     * @return the sender server ID
     *
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#getSenderServerID()
     */
    public Long getSenderServerID()
    {
        return senderServerID;
    }

    /**
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#setSenderServerID(java.lang.Long)
     */
    public void setSenderServerID(Long senderServerID)
    {
        this.senderServerID = senderServerID;
    }

    /**
     * To JSON.
     *
     * @return the string
     *
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#toJSON()
     */
    public String toJSON()
    {
        return JSONObject.valueToString(this);
    }
}
