/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager.messages;

import pt.digitalis.dif.servermanager.ServerApplicationNodeInstance;
import pt.digitalis.dif.servermanager.ServerMessageDestinationServers;
import pt.digitalis.dif.servermanager.ServerMessageExecutionResult;

/**
 * The Interface IServerMessage.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 10, 2019
 */
public interface IServerMessage
{

    /**
     * Execute.
     *
     * @param sender the sender
     *
     * @return the server message execution result
     */
    public ServerMessageExecutionResult execute(ServerApplicationNodeInstance sender);

    /**
     * Gets the destination servers type.
     *
     * @return the destination servers type
     */
    public ServerMessageDestinationServers getDestinationServersType();

    /**
     * Gets the message type ID.
     *
     * @return the message type ID
     */
    public String getMessageTypeID();

    /**
     * Gets the sender server ID.
     *
     * @return the sender server ID
     */
    public Long getSenderServerID();

    /**
     * @param senderServerID the senderServerID to set
     */
    public void setSenderServerID(Long senderServerID);

    /**
     * To JSON.
     *
     * @return the string
     */
    public String toJSON();
}
