/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager.messages;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.servermanager.ServerApplicationNodeInstance;
import pt.digitalis.dif.servermanager.ServerManager;
import pt.digitalis.dif.servermanager.ServerManagerException;
import pt.digitalis.dif.servermanager.ServerMessageDestinationServers;
import pt.digitalis.dif.servermanager.ServerMessageExecutionResult;
import pt.digitalis.dif.utils.logging.DIFLoggerInterceptorImpl;
import pt.digitalis.dif.utils.logging.LoggingConfiguration;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

/**
 * The Class ServerMessageRefreshMessages.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 10, 2019
 */
@ServerMessageTypeID("refreshConfigurations")
public class ServerMessageRefreshConfigurations extends AbstractServerMessage
{

    /**
     * Refresh configuration for a given node.
     *
     * @param configurationPath the configuration path
     *
     * @exception ConfigurationException
     */
    public static void refreshConfiguration(String configurationPath) throws ConfigurationException
    {
        Class<?> clazz =
                DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class).getCacheConfigurationPoints()
                        .get(configurationPath);

        if (clazz != null)
        {
            // Clean the instance by setting to null the static field, so that the configurations can be re-read.
            try
            {
                for (Field field : clazz.getDeclaredFields())
                {
                    Type type = field.getGenericType();
                    if (type == clazz)
                    {
                        field.setAccessible(true);
                        field.set(clazz, null);
                        break;
                    }
                    else if (type instanceof ParameterizedType && ((ParameterizedType) type).getRawType() == Map.class)
                    {
                        for (Type typeGeneric : (((ParameterizedType) type).getActualTypeArguments()))
                        {
                            if (typeGeneric == clazz)
                            {
                                field.setAccessible(true);
                                @SuppressWarnings("rawtypes")
                                Map map = (Map) field.get(clazz);
                                if (map != null)
                                {
                                    map.clear();
                                    break;
                                }
                            }
                        }
                    }
                }

                if (clazz == LoggingConfiguration.class)
                {
                    DIFLoggerInterceptorImpl.reavaluateInterceptorState();
                }
            }
            catch (SecurityException e)
            {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e)
            {
                e.printStackTrace();
            }
            catch (IllegalAccessException e)
            {
                e.printStackTrace();
            }
        }
    }

    /**
     * Refresh all configurations
     *
     * @exception ConfigurationException
     */
    public static void refreshConfigurations() throws ConfigurationException
    {
        IConfigurations configs = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);
        configs.readConfigurationsPointsForPackage("pt");

        for (String configPointPath : configs.getCacheConfigurationPoints().keySet())
        {
            refreshConfiguration(configPointPath);
        }
    }

    /**
     * Send message to all servers.
     *
     * @exception ServerManagerException
     */
    public static void sendMessage() throws ServerManagerException
    {
        ServerManager.getInstance().sendMessage(new ServerMessageRefreshConfigurations());
    }

    /**
     * Execute.
     *
     * @param sender the sender
     *
     * @return the server message execution result
     *
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#execute(pt.digitalis.dif.servermanager.ServerApplicationNodeInstance)
     */
    public ServerMessageExecutionResult execute(ServerApplicationNodeInstance sender)
    {
        try
        {
            refreshConfigurations();
            return new ServerMessageExecutionResult(true);
        }
        catch (ConfigurationException e)
        {
            return new ServerMessageExecutionResult(e);
        }
    }

    /**
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#getDestinationServersType()
     */
    public ServerMessageDestinationServers getDestinationServersType()
    {
        return ServerMessageDestinationServers.ALL;
    }
}
