/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.dif.servermanager.messages;

import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.dem.managers.ITemplateManager;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.servermanager.ServerApplicationNodeInstance;
import pt.digitalis.dif.servermanager.ServerManager;
import pt.digitalis.dif.servermanager.ServerManagerException;
import pt.digitalis.dif.servermanager.ServerMessageDestinationServers;
import pt.digitalis.dif.servermanager.ServerMessageExecutionResult;

/**
 * The Class ServerMessageRefreshMessages.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created May 10, 2019
 */
@ServerMessageTypeID("refreshMessages")
public class ServerMessageRefreshMessages extends AbstractServerMessage
{

    /**
     * Send message to all servers.
     *
     * @exception ServerManagerException
     */
    public static void sendMessage() throws ServerManagerException
    {
        ServerManager.getInstance().sendMessage(new ServerMessageRefreshMessages());
    }

    /**
     * Execute.
     *
     * @param sender the sender
     *
     * @return the server message execution result
     *
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#execute(pt.digitalis.dif.servermanager.ServerApplicationNodeInstance)
     */
    public ServerMessageExecutionResult execute(ServerApplicationNodeInstance sender)
    {
        DIFIoCRegistry.getRegistry().getImplementation(IMessageManager.class).refreshCache();
        DIFIoCRegistry.getRegistry().getImplementation(ITemplateManager.class).refreshCache();

        return new ServerMessageExecutionResult(true);
    }

    /**
     * @see pt.digitalis.dif.servermanager.messages.IServerMessage#getDestinationServersType()
     */
    public ServerMessageDestinationServers getDestinationServersType()
    {
        return ServerMessageDestinationServers.ALL;
    }
}
