/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.startup;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigAlias;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * Configuration object for framework error handling parameters.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 7 de Abr de 2011
 */
@ConfigID("dif2")
@ConfigSectionID("ErrorHandling")
public class DIFErrorHandingConfiguration
{

    /**
     * The singleton instance
     */
    static private DIFErrorHandingConfiguration instance = null;

    /**
     * allow issue reporting
     */
    private boolean allowCustomDestinationMail;

    /**
     * allow issue reporting
     */
    private boolean allowReportIssue;

    /**
     * allow view error details
     */
    private boolean allowViewErrorDetails;

    /**
     * allow issue reporting
     */
    private boolean automaticReportIssue;

    /**
     * The Error log table purge max entries.
     */
    private Long errorLogTablePurgeMaxEntries;

    /**
     * The Error log table purge max days.
     */
    private Long errorLogTablePurgeMaxDays;

    /**
     * allow issue reporting
     */
    private String reportIssueDestinationMail;

    /**
     * allow issue reporting
     */
    private String reportIssueDestinationMailControlledEnvirionment;

    /**
     * Returns the active configuration object instance.
     *
     * @return the configuration instance
     */
    @ConfigIgnore
    static public DIFErrorHandingConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(DIFErrorHandingConfiguration.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /**
     * Gets error log table purge max days.
     *
     * @return the error log table purge max days
     */
    @ConfigDefault("180")
    @ConfigAlias(name = "Error log table (purge after max age reached)",
            description = "The maximum age in days of entries to keep. When it is reached a purge will begin deleting older entries a block at a time until the max limit is reached.")
    public Long getErrorLogTablePurgeMaxDays()
    {
        return errorLogTablePurgeMaxDays;
    }

    /**
     * Sets error log table purge max days.
     *
     * @param errorLogTablePurgeMaxDays the error log table purge max days
     */
    public void setErrorLogTablePurgeMaxDays(Long errorLogTablePurgeMaxDays)
    {
        this.errorLogTablePurgeMaxDays = errorLogTablePurgeMaxDays;
    }

    /**
     * Gets error log table purge max entries.
     *
     * @return the error log table purge max entries
     */
    @ConfigDefault("100000")
    @ConfigAlias(name = "Error log table (purge after max entries reached)",
            description = "The maximum number of entries to keep. When it is reached a purge will begin deleting older entries a block at a time until the max limit is reached.")
    public Long getErrorLogTablePurgeMaxEntries()
    {
        return errorLogTablePurgeMaxEntries;
    }

    /**
     * Sets error log table purge max entries.
     *
     * @param errorLogTablePurgeMaxEntries the error log table purge max entries
     */
    public void setErrorLogTablePurgeMaxEntries(Long errorLogTablePurgeMaxEntries)
    {
        this.errorLogTablePurgeMaxEntries = errorLogTablePurgeMaxEntries;
    }

    /**
     * Inspector for the 'reportIssueDestinationMail' attribute.
     *
     * @return the reportIssueDestinationMail value
     */
    @ConfigDefault("support@somedomain.pt")
    public String getReportIssueDestinationMail()
    {
        return reportIssueDestinationMail;
    }

    /**
     * Modifier for the 'reportIssueDestinationMail' attribute.
     *
     * @param reportIssueDestinationMail the new reportIssueDestinationMail value to set
     */
    public void setReportIssueDestinationMail(String reportIssueDestinationMail)
    {
        this.reportIssueDestinationMail = reportIssueDestinationMail;
    }

    /**
     * Inspector for the 'reportIssueDestinationMailControlledEnvirionment' attribute.
     *
     * @return the reportIssueDestinationMailControlledEnvirionment value
     */
    @ConfigDefault("suporte@digitalis.pt")
    public String getReportIssueDestinationMailControlledEnvirionment()
    {
        return reportIssueDestinationMailControlledEnvirionment;
    }

    /**
     * Modifier for the 'reportIssueDestinationMailControlledEnvirionment' attribute.
     *
     * @param reportIssueDestinationMailControlledEnvirionment the new reportIssueDestinationMailControlledEnvirionment
     *                                                         value to set
     */
    public void setReportIssueDestinationMailControlledEnvirionment(
            String reportIssueDestinationMailControlledEnvirionment)
    {
        this.reportIssueDestinationMailControlledEnvirionment = reportIssueDestinationMailControlledEnvirionment;
    }

    /**
     * Inspector for the 'allowCustomDestinationMail' attribute.
     *
     * @return the allowCustomDestinationMail value
     */
    @ConfigDefault("false")
    public boolean isAllowCustomDestinationMail()
    {
        return allowCustomDestinationMail;
    }

    /**
     * Modifier for the 'allowCustomDestinationMail' attribute.
     *
     * @param allowCustomDestinationMail the new allowCustomDestinationMail value to set
     */
    public void setAllowCustomDestinationMail(boolean allowCustomDestinationMail)
    {
        this.allowCustomDestinationMail = allowCustomDestinationMail;
    }

    /**
     * Inspector for the 'allowReportIssue' attribute.
     *
     * @return the allowReportIssue value
     */
    @ConfigDefault("false")
    public boolean isAllowReportIssue()
    {
        return allowReportIssue;
    }

    /**
     * Modifier for the 'allowReportIssue' attribute.
     *
     * @param allowReportIssue the new allowReportIssue value to set
     */
    public void setAllowReportIssue(boolean allowReportIssue)
    {
        this.allowReportIssue = allowReportIssue;
    }

    /**
     * Inspector for the 'allowViewErrorDetails' attribute.
     *
     * @return the allowViewErrorDetails value
     */
    @ConfigDefault("true")
    public boolean isAllowViewErrorDetails()
    {
        return allowViewErrorDetails;
    }

    /**
     * Modifier for the 'allowViewErrorDetails' attribute.
     *
     * @param allowViewErrorDetails the new allowViewErrorDetails value to set
     */
    public void setAllowViewErrorDetails(boolean allowViewErrorDetails)
    {
        this.allowViewErrorDetails = allowViewErrorDetails;
    }

    /**
     * Inspector for the 'automaticReportIssue' attribute.
     *
     * @return the automaticReportIssue value
     */
    @ConfigDefault("false")
    public boolean isAutomaticReportIssue()
    {
        return automaticReportIssue;
    }

    /**
     * Modifier for the 'automaticReportIssue' attribute.
     *
     * @param automaticReportIssue the new automaticReportIssue value to set
     */
    public void setAutomaticReportIssue(boolean automaticReportIssue)
    {
        this.automaticReportIssue = automaticReportIssue;
    }
}
