/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.startup;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigAlias;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * Configuration object for framework parameters.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Dec 12, 2007
 */
@ConfigID("dif2")
@ConfigSectionID("GeneralConfigurations")
public class DIFGeneralConfigurationParameters
{

    /**
     * The singleton instance
     */
    static private DIFGeneralConfigurationParameters instance = null;

    /** The allow configuration set administration. */
    private Boolean allowConfigurationSetAdministration;

    /** The client name */
    private String client;

    /** The default language for messages */
    private String defaultLanguage;

    /** The keep prefs file when in replica mode. */
    private Boolean keepPrefsFileWhenInReplicaMode;

    /**
     * If the pools persist their actions to database. Dictates if the pools are prefixed with the machine ID (MAC
     * address)
     */
    private Boolean persistPoolsPrefixMachineID;

    /** The seconds for identity manager cache reload. */
    private Long secondsForIdentityManagerCacheReload;

    /** The interval in seconds that DIF collects inactive sessions */
    private Long secondsForSessionCleanup;

    /**
     * Time after the session has timed out that the cleanup Collection will consider before purging the session (ms).
     */
    private Long sessionExpirationTimeAfterTimeout;

    /** The session time out value (ms). */
    private Long sessionTimeout;

    /** If T will handle white-space-only-content parameters values as a null value submit */
    private Boolean treatWhiteSpacesOnlyParametersAsNull;

    /**
     * Returns the active configuration object instance.
     *
     * @return the configuration instance
     */
    @ConfigIgnore
    static public DIFGeneralConfigurationParameters getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(DIFGeneralConfigurationParameters.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /**
     * @return the allowConfigurationSetAdministration
     */
    @ConfigDefault("false")
    @ConfigAlias(name = "Allow use of configurations sets",
            description = "This mode allow the creation of configurations in bundles that can be shared by sereval servers/applications.")
    public Boolean getAllowConfigurationSetAdministration()
    {
        return allowConfigurationSetAdministration;
    }

    /**
     * @param allowConfigurationSetAdministration the allowConfigurationSetAdministration to set
     */
    public void setAllowConfigurationSetAdministration(Boolean allowConfigurationSetAdministration)
    {
        this.allowConfigurationSetAdministration = allowConfigurationSetAdministration;
    }

    /**
     * Inspector for the 'client' attribute.
     *
     * @return the client value
     */
    @ConfigDefault("")
    public String getClient()
    {
        return client;
    }

    /**
     * Modifier for the 'client' attribute.
     *
     * @param client the new client value to set
     */
    public void setClient(String client)
    {
        this.client = client;
    }

    /**
     * Inspector for the default language property.
     *
     * @return the default language value
     */
    @ConfigDefault("en")
    public String getDefaultLanguage()
    {
        return defaultLanguage;
    }

    /**
     * Modifier for the default language property.
     *
     * @param defaultLanguage the new default language value to set
     */
    public void setDefaultLanguage(String defaultLanguage)
    {
        this.defaultLanguage = defaultLanguage.toLowerCase();
    }

    /**
     * @return the keepPrefsFileWhenInReplicaMode
     */
    @ConfigDefault("false")
    @ConfigAlias(
            name = "Keep changed configurations in \"replica.prefs\" when in replicaMode and the configurations are persisted in database?",
            description = "In replicas it is normal to overwrite a database with the production one and since the configurations are in the database they would be lost. This mode allow the creation of configurations in bundles that can be shared by sereval servers/applications.<br/><b>WARNING:</b> This means that changes to the configurations in the database directly will be lost on restart since the ones kept the the file will overwrite them.")
    public Boolean getKeepPrefsFileWhenInReplicaMode()
    {
        return keepPrefsFileWhenInReplicaMode;
    }

    /**
     * @param keepPrefsFileWhenInReplicaMode the keepPrefsFileWhenInReplicaMode to set
     */
    public void setKeepPrefsFileWhenInReplicaMode(Boolean keepPrefsFileWhenInReplicaMode)
    {
        this.keepPrefsFileWhenInReplicaMode = keepPrefsFileWhenInReplicaMode;
    }

    /**
     * @return the persistPoolsPrefixMachineID
     */
    @ConfigDefault("true")
    public Boolean getPersistPoolsPrefixMachineID()
    {
        return persistPoolsPrefixMachineID;
    }

    /**
     * @param persistPoolsPrefixMachineID the persistPoolsPrefixMachineID to set
     */
    public void setPersistPoolsPrefixMachineID(Boolean persistPoolsPrefixMachineID)
    {
        this.persistPoolsPrefixMachineID = persistPoolsPrefixMachineID;
    }

    /**
     * Inspector for the 'secondsForIdentityManagerCacheReload' attribute.
     *
     * @return the secondsForIdentityManagerCacheReload value
     */
    @ConfigDefault("86400")
    public Long getSecondsForIdentityManagerCacheReload()
    {
        return secondsForIdentityManagerCacheReload;
    }

    /**
     * Modifier for the 'secondsForIdentityManagerCacheReload' attribute.
     *
     * @param secondsForIdentityManagerCacheReload the new secondsForIdentityManagerCacheReload value to set
     */
    public void setSecondsForIdentityManagerCacheReload(Long secondsForIdentityManagerCacheReload)
    {
        this.secondsForIdentityManagerCacheReload = secondsForIdentityManagerCacheReload;
    }

    /**
     * Inspector for the session collection time property.
     *
     * @return the session collection time property value
     */
    @ConfigDefault("1800")
    public Long getSecondsForSessionCleanup()
    {
        return secondsForSessionCleanup;
    }

    /**
     * Modifier for the session collection time property.
     *
     * @param secondsForSessionCleanup the session collection time property value to set
     */
    public void setSecondsForSessionCleanup(Long secondsForSessionCleanup)
    {
        this.secondsForSessionCleanup = secondsForSessionCleanup;
    }

    /**
     * @return the sessionExpirationTimeAfterTimeout
     */
    public Long getSessionExpirationTimeAfterTimeout()
    {
        return sessionExpirationTimeAfterTimeout;
    }

    /**
     * @param sessionExpirationTimeAfterTimeout
     */
    public void setSessionExpirationTimeAfterTimeout(Long sessionExpirationTimeAfterTimeout)
    {
        this.sessionExpirationTimeAfterTimeout = sessionExpirationTimeAfterTimeout;
    }

    /**
     * Returns the defined session time out value. Default value is 30 minutes.
     *
     * @return the defined sessionTimeout value
     */
    @ConfigDefault("1800000")
    public Long getSessionTimeout()
    {
        return this.sessionTimeout;
    }

    /**
     * Sets the new session timeout value.
     *
     * @param sessionTimeout the sessionTimeout to set
     */
    public void setSessionTimeout(Long sessionTimeout)
    {
        this.sessionTimeout = sessionTimeout;
    }

    /**
     * Inspector for the 'treatWhiteSpacesOnlyParametersAsNull' attribute.
     *
     * @return the treatWhiteSpacesOnlyParametersAsNull value
     */
    @ConfigDefault("true")
    public Boolean getTreatWhiteSpacesOnlyParametersAsNull()
    {
        return treatWhiteSpacesOnlyParametersAsNull;
    }

    /**
     * Modifier for the 'treatWhiteSpacesOnlyParametersAsNull' attribute.
     *
     * @param treatWhiteSpacesOnlyParametersAsNull the new treatWhiteSpacesOnlyParametersAsNull value to set
     */
    public void setTreatWhiteSpacesOnlyParametersAsNull(Boolean treatWhiteSpacesOnlyParametersAsNull)
    {
        this.treatWhiteSpacesOnlyParametersAsNull = treatWhiteSpacesOnlyParametersAsNull;
    }
}
