package pt.digitalis.dif.startup;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigVirtualPathForNode;

/**
 * @author Joo Galaio <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 16/07/2019
 */
@ConfigID("dif2")
@ConfigSectionID("NewRelicMonitorization")
@ConfigVirtualPathForNode("dif2/Integrations/Analytics/New Relic Monitorization")
public class NewRelicMonitorizationConfiguration
{

    /**
     * The singleton instance
     */
    static private NewRelicMonitorizationConfiguration instance = null;

    /** New Relic Enable */
    private Boolean enabled;

    /**
     * Returns the active configuration object instance.
     *
     * @return the configuration instance
     */
    @ConfigIgnore
    static public NewRelicMonitorizationConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(NewRelicMonitorizationConfiguration.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /**
     * @return the enable
     */
    @ConfigDefault("false")
    public Boolean getEnabled()
    {
        return enabled;
    }

    /**
     * @param enabled the enable to set
     */
    public void setEnabled(Boolean enabled)
    {
        this.enabled = enabled;
    }
}
