package pt.digitalis.dif.startup;

import java.util.ArrayList;
import java.util.List;

/**
 * The type Startup check result.
 */
public class StartupCheckResult
{

    /**
     * The Success.
     */
    private boolean success;

    /**
     * The Errors.
     */
    private List<String> errors = new ArrayList<String>();

    /**
     * Instantiates a new Startup check result.
     *
     * @param success the success
     */
    public StartupCheckResult(boolean success)
    {
        this.success = success;
    }

    /**
     * Instantiates a new Startup check result.
     *
     * @param success the success
     * @param errors  the errors
     */
    public StartupCheckResult(boolean success, List<String> errors)
    {
        this.success = success;
        this.errors = errors;
    }

    /**
     * Gets errors.
     *
     * @return the errors
     */
    public List<String> getErrors()
    {
        return errors;
    }

    /**
     * Is success boolean.
     *
     * @return the boolean
     */
    public boolean isSuccess()
    {
        return success;
    }
}
